package zio.aws.eks.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{
  LabelKey,
  TagValue,
  BoxedInteger,
  LabelValue,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateNodegroupRequest(
    clusterName: String,
    nodegroupName: String,
    scalingConfig: Option[zio.aws.eks.model.NodegroupScalingConfig] = None,
    diskSize: Option[BoxedInteger] = None,
    subnets: Iterable[String],
    instanceTypes: Option[Iterable[String]] = None,
    amiType: Option[zio.aws.eks.model.AMITypes] = None,
    remoteAccess: Option[zio.aws.eks.model.RemoteAccessConfig] = None,
    nodeRole: String,
    labels: Option[Map[LabelKey, LabelValue]] = None,
    taints: Option[Iterable[zio.aws.eks.model.Taint]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    clientRequestToken: Option[String] = None,
    launchTemplate: Option[zio.aws.eks.model.LaunchTemplateSpecification] =
      None,
    updateConfig: Option[zio.aws.eks.model.NodegroupUpdateConfig] = None,
    capacityType: Option[zio.aws.eks.model.CapacityTypes] = None,
    version: Option[String] = None,
    releaseVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateNodegroupRequest = {
    import CreateNodegroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodegroupName(nodegroupName: java.lang.String)
      .optionallyWith(scalingConfig.map(value => value.buildAwsValue()))(
        _.scalingConfig
      )
      .optionallyWith(
        diskSize.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.diskSize)
      .subnets(subnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(amiType.map(value => value.unwrap))(_.amiType)
      .optionallyWith(remoteAccess.map(value => value.buildAwsValue()))(
        _.remoteAccess
      )
      .nodeRole(nodeRole: java.lang.String)
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (LabelKey.unwrap(key): java.lang.String) -> (LabelValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .optionallyWith(
        taints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taints)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(clientRequestToken.map(value => value: java.lang.String))(
        _.clientRequestToken
      )
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(updateConfig.map(value => value.buildAwsValue()))(
        _.updateConfig
      )
      .optionallyWith(capacityType.map(value => value.unwrap))(_.capacityType)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(releaseVersion.map(value => value: java.lang.String))(
        _.releaseVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateNodegroupRequest.ReadOnly =
    zio.aws.eks.model.CreateNodegroupRequest.wrap(buildAwsValue())
}
object CreateNodegroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateNodegroupRequest =
      zio.aws.eks.model.CreateNodegroupRequest(
        clusterName,
        nodegroupName,
        scalingConfig.map(value => value.asEditable),
        diskSize.map(value => value),
        subnets,
        instanceTypes.map(value => value),
        amiType.map(value => value),
        remoteAccess.map(value => value.asEditable),
        nodeRole,
        labels.map(value => value),
        taints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        clientRequestToken.map(value => value),
        launchTemplate.map(value => value.asEditable),
        updateConfig.map(value => value.asEditable),
        capacityType.map(value => value),
        version.map(value => value),
        releaseVersion.map(value => value)
      )
    def clusterName: String
    def nodegroupName: String
    def scalingConfig: Option[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly]
    def diskSize: Option[BoxedInteger]
    def subnets: List[String]
    def instanceTypes: Option[List[String]]
    def amiType: Option[zio.aws.eks.model.AMITypes]
    def remoteAccess: Option[zio.aws.eks.model.RemoteAccessConfig.ReadOnly]
    def nodeRole: String
    def labels: Option[Map[LabelKey, LabelValue]]
    def taints: Option[List[zio.aws.eks.model.Taint.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def clientRequestToken: Option[String]
    def launchTemplate
        : Option[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly]
    def updateConfig: Option[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly]
    def capacityType: Option[zio.aws.eks.model.CapacityTypes]
    def version: Option[String]
    def releaseVersion: Option[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getNodegroupName: ZIO[Any, Nothing, String] = ZIO.succeed(nodegroupName)
    def getScalingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.NodegroupScalingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("scalingConfig", scalingConfig)
    def getDiskSize: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("diskSize", diskSize)
    def getSubnets: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnets)
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getAmiType: ZIO[Any, AwsError, zio.aws.eks.model.AMITypes] =
      AwsError.unwrapOptionField("amiType", amiType)
    def getRemoteAccess
        : ZIO[Any, AwsError, zio.aws.eks.model.RemoteAccessConfig.ReadOnly] =
      AwsError.unwrapOptionField("remoteAccess", remoteAccess)
    def getNodeRole: ZIO[Any, Nothing, String] = ZIO.succeed(nodeRole)
    def getLabels: ZIO[Any, AwsError, Map[LabelKey, LabelValue]] =
      AwsError.unwrapOptionField("labels", labels)
    def getTaints: ZIO[Any, AwsError, List[zio.aws.eks.model.Taint.ReadOnly]] =
      AwsError.unwrapOptionField("taints", taints)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getUpdateConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] =
      AwsError.unwrapOptionField("updateConfig", updateConfig)
    def getCapacityType: ZIO[Any, AwsError, zio.aws.eks.model.CapacityTypes] =
      AwsError.unwrapOptionField("capacityType", capacityType)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getReleaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseVersion", releaseVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
  ) extends zio.aws.eks.model.CreateNodegroupRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val nodegroupName: String = impl.nodegroupName(): String
    override val scalingConfig
        : Option[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly] = scala
      .Option(impl.scalingConfig())
      .map(value => zio.aws.eks.model.NodegroupScalingConfig.wrap(value))
    override val diskSize: Option[BoxedInteger] = scala
      .Option(impl.diskSize())
      .map(value => zio.aws.eks.model.primitives.BoxedInteger(value))
    override val subnets: List[String] = impl
      .subnets()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val instanceTypes: Option[List[String]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val amiType: Option[zio.aws.eks.model.AMITypes] = scala
      .Option(impl.amiType())
      .map(value => zio.aws.eks.model.AMITypes.wrap(value))
    override val remoteAccess
        : Option[zio.aws.eks.model.RemoteAccessConfig.ReadOnly] = scala
      .Option(impl.remoteAccess())
      .map(value => zio.aws.eks.model.RemoteAccessConfig.wrap(value))
    override val nodeRole: String = impl.nodeRole(): String
    override val labels: Option[Map[LabelKey, LabelValue]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .LabelKey(key) -> zio.aws.eks.model.primitives.LabelValue(value)
          })
          .toMap
      )
    override val taints: Option[List[zio.aws.eks.model.Taint.ReadOnly]] = scala
      .Option(impl.taints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eks.model.Taint.wrap(item)
        }.toList
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientRequestToken: Option[String] =
      scala.Option(impl.clientRequestToken()).map(value => value: String)
    override val launchTemplate
        : Option[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly] = scala
      .Option(impl.launchTemplate())
      .map(value => zio.aws.eks.model.LaunchTemplateSpecification.wrap(value))
    override val updateConfig
        : Option[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] = scala
      .Option(impl.updateConfig())
      .map(value => zio.aws.eks.model.NodegroupUpdateConfig.wrap(value))
    override val capacityType: Option[zio.aws.eks.model.CapacityTypes] = scala
      .Option(impl.capacityType())
      .map(value => zio.aws.eks.model.CapacityTypes.wrap(value))
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val releaseVersion: Option[String] =
      scala.Option(impl.releaseVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateNodegroupRequest
  ): zio.aws.eks.model.CreateNodegroupRequest.ReadOnly = new Wrapper(impl)
}
