package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait TransitionToIARules {
  def unwrap: software.amazon.awssdk.services.efs.model.TransitionToIARules
}
object TransitionToIARules {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.TransitionToIARules
  ): zio.aws.efs.model.TransitionToIARules = value match {
    case software.amazon.awssdk.services.efs.model.TransitionToIARules.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_7_DAYS =>
      val r = AFTER_7_DAYS
      r
    case software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_14_DAYS =>
      val r = AFTER_14_DAYS
      r
    case software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_30_DAYS =>
      val r = AFTER_30_DAYS
      r
    case software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_60_DAYS =>
      val r = AFTER_60_DAYS
      r
    case software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_90_DAYS =>
      val r = AFTER_90_DAYS
      r
    case software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_1_DAY =>
      val r = AFTER_1_DAY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.efs.model.TransitionToIARules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToIARules =
      software.amazon.awssdk.services.efs.model.TransitionToIARules.UNKNOWN_TO_SDK_VERSION
  }
  case object AFTER_7_DAYS extends zio.aws.efs.model.TransitionToIARules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToIARules =
      software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_7_DAYS
  }
  case object AFTER_14_DAYS extends zio.aws.efs.model.TransitionToIARules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToIARules =
      software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_14_DAYS
  }
  case object AFTER_30_DAYS extends zio.aws.efs.model.TransitionToIARules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToIARules =
      software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_30_DAYS
  }
  case object AFTER_60_DAYS extends zio.aws.efs.model.TransitionToIARules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToIARules =
      software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_60_DAYS
  }
  case object AFTER_90_DAYS extends zio.aws.efs.model.TransitionToIARules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToIARules =
      software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_90_DAYS
  }
  case object AFTER_1_DAY extends zio.aws.efs.model.TransitionToIARules {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.TransitionToIARules =
      software.amazon.awssdk.services.efs.model.TransitionToIARules.AFTER_1_DAY
  }
}
