package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationStatus {
  def unwrap: software.amazon.awssdk.services.efs.model.ReplicationStatus
}
object ReplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.ReplicationStatus
  ): zio.aws.efs.model.ReplicationStatus = value match {
    case software.amazon.awssdk.services.efs.model.ReplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.ReplicationStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.efs.model.ReplicationStatus.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.efs.model.ReplicationStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.efs.model.ReplicationStatus.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.efs.model.ReplicationStatus.PAUSED =>
      val r = PAUSED
      r
    case software.amazon.awssdk.services.efs.model.ReplicationStatus.PAUSING =>
      val r = PAUSING
      r
  }
  case object unknownToSdkVersion extends zio.aws.efs.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ReplicationStatus =
      software.amazon.awssdk.services.efs.model.ReplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.efs.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ReplicationStatus =
      software.amazon.awssdk.services.efs.model.ReplicationStatus.ENABLED
  }
  case object ENABLING extends zio.aws.efs.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ReplicationStatus =
      software.amazon.awssdk.services.efs.model.ReplicationStatus.ENABLING
  }
  case object DELETING extends zio.aws.efs.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ReplicationStatus =
      software.amazon.awssdk.services.efs.model.ReplicationStatus.DELETING
  }
  case object ERROR extends zio.aws.efs.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ReplicationStatus =
      software.amazon.awssdk.services.efs.model.ReplicationStatus.ERROR
  }
  case object PAUSED extends zio.aws.efs.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ReplicationStatus =
      software.amazon.awssdk.services.efs.model.ReplicationStatus.PAUSED
  }
  case object PAUSING extends zio.aws.efs.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.ReplicationStatus =
      software.amazon.awssdk.services.efs.model.ReplicationStatus.PAUSING
  }
}
