package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLifecycleConfigurationResponse(
    lifecyclePolicies: Optional[Iterable[zio.aws.efs.model.LifecyclePolicy]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse = {
    import DescribeLifecycleConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse
      .builder()
      .optionallyWith(
        lifecyclePolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecyclePolicies)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly =
    zio.aws.efs.model.DescribeLifecycleConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeLifecycleConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeLifecycleConfigurationResponse =
      zio.aws.efs.model.DescribeLifecycleConfigurationResponse(
        lifecyclePolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lifecyclePolicies
        : Optional[List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]]
    def getLifecyclePolicies
        : ZIO[Any, AwsError, List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]] =
      AwsError.unwrapOptionField("lifecyclePolicies", lifecyclePolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse
  ) extends zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly {
    override val lifecyclePolicies
        : Optional[List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecyclePolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.LifecyclePolicy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse
  ): zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
