package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceIdPreference(
    resourceIdType: Optional[zio.aws.efs.model.ResourceIdType] =
      Optional.Absent,
    resources: Optional[Iterable[zio.aws.efs.model.Resource]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.ResourceIdPreference = {
    import ResourceIdPreference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.ResourceIdPreference
      .builder()
      .optionallyWith(resourceIdType.map(value => value.unwrap))(
        _.resourceIdType
      )
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourcesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.ResourceIdPreference.ReadOnly =
    zio.aws.efs.model.ResourceIdPreference.wrap(buildAwsValue())
}
object ResourceIdPreference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.ResourceIdPreference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.ResourceIdPreference =
      zio.aws.efs.model.ResourceIdPreference(
        resourceIdType.map(value => value),
        resources.map(value => value)
      )
    def resourceIdType: Optional[zio.aws.efs.model.ResourceIdType]
    def resources: Optional[List[zio.aws.efs.model.Resource]]
    def getResourceIdType
        : ZIO[Any, AwsError, zio.aws.efs.model.ResourceIdType] =
      AwsError.unwrapOptionField("resourceIdType", resourceIdType)
    def getResources: ZIO[Any, AwsError, List[zio.aws.efs.model.Resource]] =
      AwsError.unwrapOptionField("resources", resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.ResourceIdPreference
  ) extends zio.aws.efs.model.ResourceIdPreference.ReadOnly {
    override val resourceIdType: Optional[zio.aws.efs.model.ResourceIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdType())
        .map(value => zio.aws.efs.model.ResourceIdType.wrap(value))
    override val resources: Optional[List[zio.aws.efs.model.Resource]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.Resource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.ResourceIdPreference
  ): zio.aws.efs.model.ResourceIdPreference.ReadOnly = new Wrapper(impl)
}
