package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutBackupPolicyResponse(
    backupPolicy: Optional[zio.aws.efs.model.BackupPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse = {
    import PutBackupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse
      .builder()
      .optionallyWith(backupPolicy.map(value => value.buildAwsValue()))(
        _.backupPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly =
    zio.aws.efs.model.PutBackupPolicyResponse.wrap(buildAwsValue())
}
object PutBackupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutBackupPolicyResponse =
      zio.aws.efs.model
        .PutBackupPolicyResponse(backupPolicy.map(value => value.asEditable))
    def backupPolicy: Optional[zio.aws.efs.model.BackupPolicy.ReadOnly]
    def getBackupPolicy
        : ZIO[Any, AwsError, zio.aws.efs.model.BackupPolicy.ReadOnly] =
      AwsError.unwrapOptionField("backupPolicy", backupPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse
  ) extends zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly {
    override val backupPolicy
        : Optional[zio.aws.efs.model.BackupPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPolicy())
        .map(value => zio.aws.efs.model.BackupPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse
  ): zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly = new Wrapper(impl)
}
