package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{Policy, FileSystemId}
import scala.jdk.CollectionConverters._
final case class PutFileSystemPolicyResponse(
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    policy: Optional[Policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse = {
    import PutFileSystemPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse
      .builder()
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly =
    zio.aws.efs.model.PutFileSystemPolicyResponse.wrap(buildAwsValue())
}
object PutFileSystemPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutFileSystemPolicyResponse =
      zio.aws.efs.model.PutFileSystemPolicyResponse(
        fileSystemId.map(value => value),
        policy.map(value => value)
      )
    def fileSystemId: Optional[FileSystemId]
    def policy: Optional[Policy]
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse
  ) extends zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly {
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.efs.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse
  ): zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly = new Wrapper(impl)
}
