package zio.aws.efs.model
import zio.aws.efs.model.primitives.{
  FileSystemId,
  AccessPointId,
  Token,
  MaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAccessPointsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    accessPointId: Optional[AccessPointId] = Optional.Absent,
    fileSystemId: Optional[FileSystemId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest = {
    import DescribeAccessPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accessPointId.map(value =>
          AccessPointId.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeAccessPointsRequest.ReadOnly =
    zio.aws.efs.model.DescribeAccessPointsRequest.wrap(buildAwsValue())
}
object DescribeAccessPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeAccessPointsRequest =
      zio.aws.efs.model.DescribeAccessPointsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        accessPointId.map(value => value),
        fileSystemId.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def accessPointId: Optional[AccessPointId]
    def fileSystemId: Optional[FileSystemId]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccessPointId: ZIO[Any, AwsError, AccessPointId] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
  ) extends zio.aws.efs.model.DescribeAccessPointsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
    override val accessPointId: Optional[AccessPointId] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPointId())
      .map(value => zio.aws.efs.model.primitives.AccessPointId(value))
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
  ): zio.aws.efs.model.DescribeAccessPointsRequest.ReadOnly = new Wrapper(impl)
}
