package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.Path
import scala.jdk.CollectionConverters._
final case class RootDirectory(
    path: Optional[Path] = Optional.Absent,
    creationInfo: Optional[zio.aws.efs.model.CreationInfo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.RootDirectory = {
    import RootDirectory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.RootDirectory
      .builder()
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(creationInfo.map(value => value.buildAwsValue()))(
        _.creationInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.efs.model.RootDirectory.ReadOnly =
    zio.aws.efs.model.RootDirectory.wrap(buildAwsValue())
}
object RootDirectory {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.efs.model.RootDirectory] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.RootDirectory =
      zio.aws.efs.model.RootDirectory(
        path.map(value => value),
        creationInfo.map(value => value.asEditable)
      )
    def path: Optional[Path]
    def creationInfo: Optional[zio.aws.efs.model.CreationInfo.ReadOnly]
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getCreationInfo
        : ZIO[Any, AwsError, zio.aws.efs.model.CreationInfo.ReadOnly] =
      AwsError.unwrapOptionField("creationInfo", creationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.RootDirectory
  ) extends zio.aws.efs.model.RootDirectory.ReadOnly {
    override val path: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.efs.model.primitives.Path(value))
    override val creationInfo
        : Optional[zio.aws.efs.model.CreationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationInfo())
        .map(value => zio.aws.efs.model.CreationInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.RootDirectory
  ): zio.aws.efs.model.RootDirectory.ReadOnly = new Wrapper(impl)
}
