package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{Policy, FileSystemId}
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemPolicyResponse(
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    policy: Optional[Policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse = {
    import DescribeFileSystemPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse
      .builder()
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly =
    zio.aws.efs.model.DescribeFileSystemPolicyResponse.wrap(buildAwsValue())
}
object DescribeFileSystemPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeFileSystemPolicyResponse =
      zio.aws.efs.model.DescribeFileSystemPolicyResponse(
        fileSystemId.map(value => value),
        policy.map(value => value)
      )
    def fileSystemId: Optional[FileSystemId]
    def policy: Optional[Policy]
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse
  ) extends zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly {
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.efs.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse
  ): zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
