package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.MountTargetId
import scala.jdk.CollectionConverters._
final case class DeleteMountTargetRequest(mountTargetId: MountTargetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest = {
    import DeleteMountTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest
      .builder()
      .mountTargetId(MountTargetId.unwrap(mountTargetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DeleteMountTargetRequest.ReadOnly =
    zio.aws.efs.model.DeleteMountTargetRequest.wrap(buildAwsValue())
}
object DeleteMountTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DeleteMountTargetRequest =
      zio.aws.efs.model.DeleteMountTargetRequest(mountTargetId)
    def mountTargetId: MountTargetId
    def getMountTargetId: ZIO[Any, Nothing, MountTargetId] =
      ZIO.succeed(mountTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest
  ) extends zio.aws.efs.model.DeleteMountTargetRequest.ReadOnly {
    override val mountTargetId: MountTargetId =
      zio.aws.efs.model.primitives.MountTargetId(impl.mountTargetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest
  ): zio.aws.efs.model.DeleteMountTargetRequest.ReadOnly = new Wrapper(impl)
}
