package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.efs.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.Status
  ): zio.aws.efs.model.Status = value match {
    case software.amazon.awssdk.services.efs.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.Status.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.efs.model.Status.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.efs.model.Status.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.efs.model.Status.DISABLING =>
      val r = DISABLING
      r
  }
  case object unknownToSdkVersion extends zio.aws.efs.model.Status {
    override def unwrap: software.amazon.awssdk.services.efs.model.Status =
      software.amazon.awssdk.services.efs.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.efs.model.Status {
    override def unwrap: software.amazon.awssdk.services.efs.model.Status =
      software.amazon.awssdk.services.efs.model.Status.ENABLED
  }
  case object ENABLING extends zio.aws.efs.model.Status {
    override def unwrap: software.amazon.awssdk.services.efs.model.Status =
      software.amazon.awssdk.services.efs.model.Status.ENABLING
  }
  case object DISABLED extends zio.aws.efs.model.Status {
    override def unwrap: software.amazon.awssdk.services.efs.model.Status =
      software.amazon.awssdk.services.efs.model.Status.DISABLED
  }
  case object DISABLING extends zio.aws.efs.model.Status {
    override def unwrap: software.amazon.awssdk.services.efs.model.Status =
      software.amazon.awssdk.services.efs.model.Status.DISABLING
  }
}
