package zio.aws.efs.model
import zio.aws.efs.model.primitives.{
  Marker,
  FileSystemId,
  MaxItems,
  AccessPointId,
  MountTargetId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeMountTargetsRequest(
    maxItems: Optional[MaxItems] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    mountTargetId: Optional[MountTargetId] = Optional.Absent,
    accessPointId: Optional[AccessPointId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest = {
    import DescribeMountTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
      .builder()
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(
        mountTargetId.map(value =>
          MountTargetId.unwrap(value): java.lang.String
        )
      )(_.mountTargetId)
      .optionallyWith(
        accessPointId.map(value =>
          AccessPointId.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeMountTargetsRequest.ReadOnly =
    zio.aws.efs.model.DescribeMountTargetsRequest.wrap(buildAwsValue())
}
object DescribeMountTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeMountTargetsRequest =
      zio.aws.efs.model.DescribeMountTargetsRequest(
        maxItems.map(value => value),
        marker.map(value => value),
        fileSystemId.map(value => value),
        mountTargetId.map(value => value),
        accessPointId.map(value => value)
      )
    def maxItems: Optional[MaxItems]
    def marker: Optional[Marker]
    def fileSystemId: Optional[FileSystemId]
    def mountTargetId: Optional[MountTargetId]
    def accessPointId: Optional[AccessPointId]
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getMountTargetId: ZIO[Any, AwsError, MountTargetId] =
      AwsError.unwrapOptionField("mountTargetId", mountTargetId)
    def getAccessPointId: ZIO[Any, AwsError, AccessPointId] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
  ) extends zio.aws.efs.model.DescribeMountTargetsRequest.ReadOnly {
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.efs.model.primitives.MaxItems(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val mountTargetId: Optional[MountTargetId] = zio.aws.core.internal
      .optionalFromNullable(impl.mountTargetId())
      .map(value => zio.aws.efs.model.primitives.MountTargetId(value))
    override val accessPointId: Optional[AccessPointId] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPointId())
      .map(value => zio.aws.efs.model.primitives.AccessPointId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
  ): zio.aws.efs.model.DescribeMountTargetsRequest.ReadOnly = new Wrapper(impl)
}
