package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemsResponse(
    marker: Optional[Marker] = Optional.Absent,
    fileSystems: Optional[Iterable[zio.aws.efs.model.FileSystemDescription]] =
      Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse = {
    import DescribeFileSystemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        fileSystems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystems)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly =
    zio.aws.efs.model.DescribeFileSystemsResponse.wrap(buildAwsValue())
}
object DescribeFileSystemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeFileSystemsResponse =
      zio.aws.efs.model.DescribeFileSystemsResponse(
        marker.map(value => value),
        fileSystems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def marker: Optional[Marker]
    def fileSystems
        : Optional[List[zio.aws.efs.model.FileSystemDescription.ReadOnly]]
    def nextMarker: Optional[Marker]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getFileSystems: ZIO[Any, AwsError, List[
      zio.aws.efs.model.FileSystemDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystems", fileSystems)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
  ) extends zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly {
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val fileSystems
        : Optional[List[zio.aws.efs.model.FileSystemDescription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.FileSystemDescription.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
  ): zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly = new Wrapper(impl)
}
