package zio.aws.efs.model
import zio.aws.efs.model.primitives.{
  FileSystemId,
  CreationToken,
  Marker,
  MaxItems
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemsRequest(
    maxItems: Optional[MaxItems] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    creationToken: Optional[CreationToken] = Optional.Absent,
    fileSystemId: Optional[FileSystemId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest = {
    import DescribeFileSystemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
      .builder()
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        creationToken.map(value =>
          CreationToken.unwrap(value): java.lang.String
        )
      )(_.creationToken)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeFileSystemsRequest.ReadOnly =
    zio.aws.efs.model.DescribeFileSystemsRequest.wrap(buildAwsValue())
}
object DescribeFileSystemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeFileSystemsRequest =
      zio.aws.efs.model.DescribeFileSystemsRequest(
        maxItems.map(value => value),
        marker.map(value => value),
        creationToken.map(value => value),
        fileSystemId.map(value => value)
      )
    def maxItems: Optional[MaxItems]
    def marker: Optional[Marker]
    def creationToken: Optional[CreationToken]
    def fileSystemId: Optional[FileSystemId]
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getCreationToken: ZIO[Any, AwsError, CreationToken] =
      AwsError.unwrapOptionField("creationToken", creationToken)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
  ) extends zio.aws.efs.model.DescribeFileSystemsRequest.ReadOnly {
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.efs.model.primitives.MaxItems(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val creationToken: Optional[CreationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.creationToken())
      .map(value => zio.aws.efs.model.primitives.CreationToken(value))
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
  ): zio.aws.efs.model.DescribeFileSystemsRequest.ReadOnly = new Wrapper(impl)
}
