package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait Resource {
  def unwrap: software.amazon.awssdk.services.efs.model.Resource
}
object Resource {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.Resource
  ): zio.aws.efs.model.Resource = value match {
    case software.amazon.awssdk.services.efs.model.Resource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.Resource.FILE_SYSTEM =>
      val r = FILE_SYSTEM
      r
    case software.amazon.awssdk.services.efs.model.Resource.MOUNT_TARGET =>
      val r = MOUNT_TARGET
      r
  }
  case object unknownToSdkVersion extends zio.aws.efs.model.Resource {
    override def unwrap: software.amazon.awssdk.services.efs.model.Resource =
      software.amazon.awssdk.services.efs.model.Resource.UNKNOWN_TO_SDK_VERSION
  }
  case object FILE_SYSTEM extends zio.aws.efs.model.Resource {
    override def unwrap: software.amazon.awssdk.services.efs.model.Resource =
      software.amazon.awssdk.services.efs.model.Resource.FILE_SYSTEM
  }
  case object MOUNT_TARGET extends zio.aws.efs.model.Resource {
    override def unwrap: software.amazon.awssdk.services.efs.model.Resource =
      software.amazon.awssdk.services.efs.model.Resource.MOUNT_TARGET
  }
}
