package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class PutLifecycleConfigurationRequest(
    fileSystemId: FileSystemId,
    lifecyclePolicies: Iterable[zio.aws.efs.model.LifecyclePolicy]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest = {
    import PutLifecycleConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .lifecyclePolicies(lifecyclePolicies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutLifecycleConfigurationRequest.ReadOnly =
    zio.aws.efs.model.PutLifecycleConfigurationRequest.wrap(buildAwsValue())
}
object PutLifecycleConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutLifecycleConfigurationRequest =
      zio.aws.efs.model.PutLifecycleConfigurationRequest(
        fileSystemId,
        lifecyclePolicies.map { item =>
          item.asEditable
        }
      )
    def fileSystemId: FileSystemId
    def lifecyclePolicies: List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getLifecyclePolicies
        : ZIO[Any, Nothing, List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]] =
      ZIO.succeed(lifecyclePolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest
  ) extends zio.aws.efs.model.PutLifecycleConfigurationRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val lifecyclePolicies
        : List[zio.aws.efs.model.LifecyclePolicy.ReadOnly] = impl
      .lifecyclePolicies()
      .asScala
      .map { item =>
        zio.aws.efs.model.LifecyclePolicy.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest
  ): zio.aws.efs.model.PutLifecycleConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
