package zio.aws.efs.model
import zio.aws.efs.model.primitives.{MaxResults, Token}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAccountPreferencesRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest = {
    import DescribeAccountPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeAccountPreferencesRequest.ReadOnly =
    zio.aws.efs.model.DescribeAccountPreferencesRequest.wrap(buildAwsValue())
}
object DescribeAccountPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeAccountPreferencesRequest =
      zio.aws.efs.model.DescribeAccountPreferencesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
  ) extends zio.aws.efs.model.DescribeAccountPreferencesRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
  ): zio.aws.efs.model.DescribeAccountPreferencesRequest.ReadOnly = new Wrapper(
    impl
  )
}
