package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeMountTargetsResponse(
    marker: Optional[Marker] = Optional.Absent,
    mountTargets: Optional[Iterable[zio.aws.efs.model.MountTargetDescription]] =
      Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse = {
    import DescribeMountTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        mountTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountTargets)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly =
    zio.aws.efs.model.DescribeMountTargetsResponse.wrap(buildAwsValue())
}
object DescribeMountTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeMountTargetsResponse =
      zio.aws.efs.model.DescribeMountTargetsResponse(
        marker.map(value => value),
        mountTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def marker: Optional[Marker]
    def mountTargets
        : Optional[List[zio.aws.efs.model.MountTargetDescription.ReadOnly]]
    def nextMarker: Optional[Marker]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getMountTargets: ZIO[Any, AwsError, List[
      zio.aws.efs.model.MountTargetDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("mountTargets", mountTargets)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
  ) extends zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly {
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val mountTargets
        : Optional[List[zio.aws.efs.model.MountTargetDescription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.MountTargetDescription.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
  ): zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly = new Wrapper(impl)
}
