package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{
  FileSystemId,
  AccessPointArn,
  ClientToken,
  Name,
  AwsAccountId,
  AccessPointId
}
import scala.jdk.CollectionConverters._
final case class AccessPointDescription(
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.efs.model.Tag]] = Optional.Absent,
    accessPointId: Optional[AccessPointId] = Optional.Absent,
    accessPointArn: Optional[AccessPointArn] = Optional.Absent,
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    posixUser: Optional[zio.aws.efs.model.PosixUser] = Optional.Absent,
    rootDirectory: Optional[zio.aws.efs.model.RootDirectory] = Optional.Absent,
    ownerId: Optional[AwsAccountId] = Optional.Absent,
    lifeCycleState: Optional[zio.aws.efs.model.LifeCycleState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.AccessPointDescription = {
    import AccessPointDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.AccessPointDescription
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        accessPointId.map(value =>
          AccessPointId.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .optionallyWith(
        accessPointArn.map(value =>
          AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(posixUser.map(value => value.buildAwsValue()))(
        _.posixUser
      )
      .optionallyWith(rootDirectory.map(value => value.buildAwsValue()))(
        _.rootDirectory
      )
      .optionallyWith(
        ownerId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(lifeCycleState.map(value => value.unwrap))(
        _.lifeCycleState
      )
      .build()
  }
  def asReadOnly: zio.aws.efs.model.AccessPointDescription.ReadOnly =
    zio.aws.efs.model.AccessPointDescription.wrap(buildAwsValue())
}
object AccessPointDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.AccessPointDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.AccessPointDescription =
      zio.aws.efs.model.AccessPointDescription(
        clientToken.map(value => value),
        name.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accessPointId.map(value => value),
        accessPointArn.map(value => value),
        fileSystemId.map(value => value),
        posixUser.map(value => value.asEditable),
        rootDirectory.map(value => value.asEditable),
        ownerId.map(value => value),
        lifeCycleState.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def name: Optional[Name]
    def tags: Optional[List[zio.aws.efs.model.Tag.ReadOnly]]
    def accessPointId: Optional[AccessPointId]
    def accessPointArn: Optional[AccessPointArn]
    def fileSystemId: Optional[FileSystemId]
    def posixUser: Optional[zio.aws.efs.model.PosixUser.ReadOnly]
    def rootDirectory: Optional[zio.aws.efs.model.RootDirectory.ReadOnly]
    def ownerId: Optional[AwsAccountId]
    def lifeCycleState: Optional[zio.aws.efs.model.LifeCycleState]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, List[zio.aws.efs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAccessPointId: ZIO[Any, AwsError, AccessPointId] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getAccessPointArn: ZIO[Any, AwsError, AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getPosixUser: ZIO[Any, AwsError, zio.aws.efs.model.PosixUser.ReadOnly] =
      AwsError.unwrapOptionField("posixUser", posixUser)
    def getRootDirectory
        : ZIO[Any, AwsError, zio.aws.efs.model.RootDirectory.ReadOnly] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
    def getOwnerId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getLifeCycleState
        : ZIO[Any, AwsError, zio.aws.efs.model.LifeCycleState] =
      AwsError.unwrapOptionField("lifeCycleState", lifeCycleState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.AccessPointDescription
  ) extends zio.aws.efs.model.AccessPointDescription.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.efs.model.primitives.ClientToken(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.efs.model.primitives.Name(value))
    override val tags: Optional[List[zio.aws.efs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.Tag.wrap(item)
          }.toList
        )
    override val accessPointId: Optional[AccessPointId] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPointId())
      .map(value => zio.aws.efs.model.primitives.AccessPointId(value))
    override val accessPointArn: Optional[AccessPointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPointArn())
        .map(value => zio.aws.efs.model.primitives.AccessPointArn(value))
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val posixUser: Optional[zio.aws.efs.model.PosixUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.posixUser())
        .map(value => zio.aws.efs.model.PosixUser.wrap(value))
    override val rootDirectory
        : Optional[zio.aws.efs.model.RootDirectory.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootDirectory())
        .map(value => zio.aws.efs.model.RootDirectory.wrap(value))
    override val ownerId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.efs.model.primitives.AwsAccountId(value))
    override val lifeCycleState: Optional[zio.aws.efs.model.LifeCycleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifeCycleState())
        .map(value => zio.aws.efs.model.LifeCycleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.AccessPointDescription
  ): zio.aws.efs.model.AccessPointDescription.ReadOnly = new Wrapper(impl)
}
