package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LifecyclePolicy(
    transitionToIA: Optional[zio.aws.efs.model.TransitionToIARules] =
      Optional.Absent,
    transitionToPrimaryStorageClass: Optional[
      zio.aws.efs.model.TransitionToPrimaryStorageClassRules
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.LifecyclePolicy = {
    import LifecyclePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.LifecyclePolicy
      .builder()
      .optionallyWith(transitionToIA.map(value => value.unwrap))(
        _.transitionToIA
      )
      .optionallyWith(
        transitionToPrimaryStorageClass.map(value => value.unwrap)
      )(_.transitionToPrimaryStorageClass)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.LifecyclePolicy.ReadOnly =
    zio.aws.efs.model.LifecyclePolicy.wrap(buildAwsValue())
}
object LifecyclePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.LifecyclePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.LifecyclePolicy =
      zio.aws.efs.model.LifecyclePolicy(
        transitionToIA.map(value => value),
        transitionToPrimaryStorageClass.map(value => value)
      )
    def transitionToIA: Optional[zio.aws.efs.model.TransitionToIARules]
    def transitionToPrimaryStorageClass
        : Optional[zio.aws.efs.model.TransitionToPrimaryStorageClassRules]
    def getTransitionToIA
        : ZIO[Any, AwsError, zio.aws.efs.model.TransitionToIARules] =
      AwsError.unwrapOptionField("transitionToIA", transitionToIA)
    def getTransitionToPrimaryStorageClass: ZIO[
      Any,
      AwsError,
      zio.aws.efs.model.TransitionToPrimaryStorageClassRules
    ] = AwsError.unwrapOptionField(
      "transitionToPrimaryStorageClass",
      transitionToPrimaryStorageClass
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.LifecyclePolicy
  ) extends zio.aws.efs.model.LifecyclePolicy.ReadOnly {
    override val transitionToIA
        : Optional[zio.aws.efs.model.TransitionToIARules] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitionToIA())
        .map(value => zio.aws.efs.model.TransitionToIARules.wrap(value))
    override val transitionToPrimaryStorageClass
        : Optional[zio.aws.efs.model.TransitionToPrimaryStorageClassRules] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitionToPrimaryStorageClass())
        .map(value =>
          zio.aws.efs.model.TransitionToPrimaryStorageClassRules.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.LifecyclePolicy
  ): zio.aws.efs.model.LifecyclePolicy.ReadOnly = new Wrapper(impl)
}
