package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{ProvisionedThroughputInMibps, FileSystemId}
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemRequest(
    fileSystemId: FileSystemId,
    throughputMode: Optional[zio.aws.efs.model.ThroughputMode] =
      Optional.Absent,
    provisionedThroughputInMibps: Optional[ProvisionedThroughputInMibps] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest = {
    import UpdateFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(throughputMode.map(value => value.unwrap))(
        _.throughputMode
      )
      .optionallyWith(
        provisionedThroughputInMibps.map(value =>
          ProvisionedThroughputInMibps.unwrap(value): java.lang.Double
        )
      )(_.provisionedThroughputInMibps)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.UpdateFileSystemRequest.ReadOnly =
    zio.aws.efs.model.UpdateFileSystemRequest.wrap(buildAwsValue())
}
object UpdateFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.UpdateFileSystemRequest =
      zio.aws.efs.model.UpdateFileSystemRequest(
        fileSystemId,
        throughputMode.map(value => value),
        provisionedThroughputInMibps.map(value => value)
      )
    def fileSystemId: FileSystemId
    def throughputMode: Optional[zio.aws.efs.model.ThroughputMode]
    def provisionedThroughputInMibps: Optional[ProvisionedThroughputInMibps]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getThroughputMode
        : ZIO[Any, AwsError, zio.aws.efs.model.ThroughputMode] =
      AwsError.unwrapOptionField("throughputMode", throughputMode)
    def getProvisionedThroughputInMibps
        : ZIO[Any, AwsError, ProvisionedThroughputInMibps] =
      AwsError.unwrapOptionField(
        "provisionedThroughputInMibps",
        provisionedThroughputInMibps
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest
  ) extends zio.aws.efs.model.UpdateFileSystemRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val throughputMode: Optional[zio.aws.efs.model.ThroughputMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputMode())
        .map(value => zio.aws.efs.model.ThroughputMode.wrap(value))
    override val provisionedThroughputInMibps
        : Optional[ProvisionedThroughputInMibps] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputInMibps())
      .map(value =>
        zio.aws.efs.model.primitives.ProvisionedThroughputInMibps(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest
  ): zio.aws.efs.model.UpdateFileSystemRequest.ReadOnly = new Wrapper(impl)
}
