package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class DeleteReplicationConfigurationRequest(
    sourceFileSystemId: FileSystemId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest = {
    import DeleteReplicationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest
      .builder()
      .sourceFileSystemId(
        FileSystemId.unwrap(sourceFileSystemId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DeleteReplicationConfigurationRequest.ReadOnly =
    zio.aws.efs.model.DeleteReplicationConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteReplicationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DeleteReplicationConfigurationRequest =
      zio.aws.efs.model
        .DeleteReplicationConfigurationRequest(sourceFileSystemId)
    def sourceFileSystemId: FileSystemId
    def getSourceFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(sourceFileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest
  ) extends zio.aws.efs.model.DeleteReplicationConfigurationRequest.ReadOnly {
    override val sourceFileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.sourceFileSystemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest
  ): zio.aws.efs.model.DeleteReplicationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
