package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.{
  Backup,
  CreationToken,
  Encrypted,
  KmsKeyId,
  AvailabilityZoneName,
  ProvisionedThroughputInMibps
}
import scala.jdk.CollectionConverters._
final case class CreateFileSystemRequest(
    creationToken: CreationToken,
    performanceMode: Optional[zio.aws.efs.model.PerformanceMode] =
      Optional.Absent,
    encrypted: Optional[Encrypted] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    throughputMode: Optional[zio.aws.efs.model.ThroughputMode] =
      Optional.Absent,
    provisionedThroughputInMibps: Optional[ProvisionedThroughputInMibps] =
      Optional.Absent,
    availabilityZoneName: Optional[AvailabilityZoneName] = Optional.Absent,
    backup: Optional[Backup] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.efs.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.CreateFileSystemRequest = {
    import CreateFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.CreateFileSystemRequest
      .builder()
      .creationToken(CreationToken.unwrap(creationToken): java.lang.String)
      .optionallyWith(performanceMode.map(value => value.unwrap))(
        _.performanceMode
      )
      .optionallyWith(
        encrypted.map(value => Encrypted.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(throughputMode.map(value => value.unwrap))(
        _.throughputMode
      )
      .optionallyWith(
        provisionedThroughputInMibps.map(value =>
          ProvisionedThroughputInMibps.unwrap(value): java.lang.Double
        )
      )(_.provisionedThroughputInMibps)
      .optionallyWith(
        availabilityZoneName.map(value =>
          AvailabilityZoneName.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneName)
      .optionallyWith(
        backup.map(value => Backup.unwrap(value): java.lang.Boolean)
      )(_.backup)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.CreateFileSystemRequest.ReadOnly =
    zio.aws.efs.model.CreateFileSystemRequest.wrap(buildAwsValue())
}
object CreateFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.CreateFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.CreateFileSystemRequest =
      zio.aws.efs.model.CreateFileSystemRequest(
        creationToken,
        performanceMode.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        throughputMode.map(value => value),
        provisionedThroughputInMibps.map(value => value),
        availabilityZoneName.map(value => value),
        backup.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def creationToken: CreationToken
    def performanceMode: Optional[zio.aws.efs.model.PerformanceMode]
    def encrypted: Optional[Encrypted]
    def kmsKeyId: Optional[KmsKeyId]
    def throughputMode: Optional[zio.aws.efs.model.ThroughputMode]
    def provisionedThroughputInMibps: Optional[ProvisionedThroughputInMibps]
    def availabilityZoneName: Optional[AvailabilityZoneName]
    def backup: Optional[Backup]
    def tags: Optional[List[zio.aws.efs.model.Tag.ReadOnly]]
    def getCreationToken: ZIO[Any, Nothing, CreationToken] =
      ZIO.succeed(creationToken)
    def getPerformanceMode
        : ZIO[Any, AwsError, zio.aws.efs.model.PerformanceMode] =
      AwsError.unwrapOptionField("performanceMode", performanceMode)
    def getEncrypted: ZIO[Any, AwsError, Encrypted] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getThroughputMode
        : ZIO[Any, AwsError, zio.aws.efs.model.ThroughputMode] =
      AwsError.unwrapOptionField("throughputMode", throughputMode)
    def getProvisionedThroughputInMibps
        : ZIO[Any, AwsError, ProvisionedThroughputInMibps] =
      AwsError.unwrapOptionField(
        "provisionedThroughputInMibps",
        provisionedThroughputInMibps
      )
    def getAvailabilityZoneName: ZIO[Any, AwsError, AvailabilityZoneName] =
      AwsError.unwrapOptionField("availabilityZoneName", availabilityZoneName)
    def getBackup: ZIO[Any, AwsError, Backup] =
      AwsError.unwrapOptionField("backup", backup)
    def getTags: ZIO[Any, AwsError, List[zio.aws.efs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.CreateFileSystemRequest
  ) extends zio.aws.efs.model.CreateFileSystemRequest.ReadOnly {
    override val creationToken: CreationToken =
      zio.aws.efs.model.primitives.CreationToken(impl.creationToken())
    override val performanceMode: Optional[zio.aws.efs.model.PerformanceMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceMode())
        .map(value => zio.aws.efs.model.PerformanceMode.wrap(value))
    override val encrypted: Optional[Encrypted] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => zio.aws.efs.model.primitives.Encrypted(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.efs.model.primitives.KmsKeyId(value))
    override val throughputMode: Optional[zio.aws.efs.model.ThroughputMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputMode())
        .map(value => zio.aws.efs.model.ThroughputMode.wrap(value))
    override val provisionedThroughputInMibps
        : Optional[ProvisionedThroughputInMibps] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputInMibps())
      .map(value =>
        zio.aws.efs.model.primitives.ProvisionedThroughputInMibps(value)
      )
    override val availabilityZoneName: Optional[AvailabilityZoneName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneName())
        .map(value => zio.aws.efs.model.primitives.AvailabilityZoneName(value))
    override val backup: Optional[Backup] = zio.aws.core.internal
      .optionalFromNullable(impl.backup())
      .map(value => zio.aws.efs.model.primitives.Backup(value))
    override val tags: Optional[List[zio.aws.efs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.CreateFileSystemRequest
  ): zio.aws.efs.model.CreateFileSystemRequest.ReadOnly = new Wrapper(impl)
}
