package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutAccountPreferencesRequest(
    resourceIdType: zio.aws.efs.model.ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest = {
    import PutAccountPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest
      .builder()
      .resourceIdType(resourceIdType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutAccountPreferencesRequest.ReadOnly =
    zio.aws.efs.model.PutAccountPreferencesRequest.wrap(buildAwsValue())
}
object PutAccountPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutAccountPreferencesRequest =
      zio.aws.efs.model.PutAccountPreferencesRequest(resourceIdType)
    def resourceIdType: zio.aws.efs.model.ResourceIdType
    def getResourceIdType: ZIO[Any, Nothing, zio.aws.efs.model.ResourceIdType] =
      ZIO.succeed(resourceIdType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest
  ) extends zio.aws.efs.model.PutAccountPreferencesRequest.ReadOnly {
    override val resourceIdType: zio.aws.efs.model.ResourceIdType =
      zio.aws.efs.model.ResourceIdType.wrap(impl.resourceIdType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest
  ): zio.aws.efs.model.PutAccountPreferencesRequest.ReadOnly = new Wrapper(impl)
}
