package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.efs.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class DescribeReplicationConfigurationsResponse(
    replications: Optional[
      Iterable[zio.aws.efs.model.ReplicationConfigurationDescription]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse = {
    import DescribeReplicationConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse
      .builder()
      .optionallyWith(
        replications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replications)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly =
    zio.aws.efs.model.DescribeReplicationConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.efs.model.DescribeReplicationConfigurationsResponse =
      zio.aws.efs.model.DescribeReplicationConfigurationsResponse(
        replications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def replications: Optional[
      List[zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getReplications: ZIO[Any, AwsError, List[
      zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replications", replications)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse
  ) extends zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly {
    override val replications: Optional[
      List[zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.efs.model.ReplicationConfigurationDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse
  ): zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
