package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.efs.model.primitives.{
  Timestamp,
  FileSystemArn,
  RegionName,
  FileSystemId
}
import scala.jdk.CollectionConverters._
final case class ReplicationConfigurationDescription(
    sourceFileSystemId: FileSystemId,
    sourceFileSystemRegion: RegionName,
    sourceFileSystemArn: FileSystemArn,
    originalSourceFileSystemArn: FileSystemArn,
    creationTime: Timestamp,
    destinations: Iterable[zio.aws.efs.model.Destination]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription = {
    import ReplicationConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription
      .builder()
      .sourceFileSystemId(
        FileSystemId.unwrap(sourceFileSystemId): java.lang.String
      )
      .sourceFileSystemRegion(
        RegionName.unwrap(sourceFileSystemRegion): java.lang.String
      )
      .sourceFileSystemArn(
        FileSystemArn.unwrap(sourceFileSystemArn): java.lang.String
      )
      .originalSourceFileSystemArn(
        FileSystemArn.unwrap(originalSourceFileSystemArn): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .destinations(destinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly =
    zio.aws.efs.model.ReplicationConfigurationDescription.wrap(buildAwsValue())
}
object ReplicationConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.ReplicationConfigurationDescription =
      zio.aws.efs.model.ReplicationConfigurationDescription(
        sourceFileSystemId,
        sourceFileSystemRegion,
        sourceFileSystemArn,
        originalSourceFileSystemArn,
        creationTime,
        destinations.map { item =>
          item.asEditable
        }
      )
    def sourceFileSystemId: FileSystemId
    def sourceFileSystemRegion: RegionName
    def sourceFileSystemArn: FileSystemArn
    def originalSourceFileSystemArn: FileSystemArn
    def creationTime: Timestamp
    def destinations: List[zio.aws.efs.model.Destination.ReadOnly]
    def getSourceFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(sourceFileSystemId)
    def getSourceFileSystemRegion: ZIO[Any, Nothing, RegionName] =
      ZIO.succeed(sourceFileSystemRegion)
    def getSourceFileSystemArn: ZIO[Any, Nothing, FileSystemArn] =
      ZIO.succeed(sourceFileSystemArn)
    def getOriginalSourceFileSystemArn: ZIO[Any, Nothing, FileSystemArn] =
      ZIO.succeed(originalSourceFileSystemArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDestinations
        : ZIO[Any, Nothing, List[zio.aws.efs.model.Destination.ReadOnly]] =
      ZIO.succeed(destinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription
  ) extends zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly {
    override val sourceFileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.sourceFileSystemId())
    override val sourceFileSystemRegion: RegionName =
      zio.aws.efs.model.primitives.RegionName(impl.sourceFileSystemRegion())
    override val sourceFileSystemArn: FileSystemArn =
      zio.aws.efs.model.primitives.FileSystemArn(impl.sourceFileSystemArn())
    override val originalSourceFileSystemArn: FileSystemArn =
      zio.aws.efs.model.primitives
        .FileSystemArn(impl.originalSourceFileSystemArn())
    override val creationTime: Timestamp =
      zio.aws.efs.model.primitives.Timestamp(impl.creationTime())
    override val destinations: List[zio.aws.efs.model.Destination.ReadOnly] =
      impl
        .destinations()
        .asScala
        .map { item =>
          zio.aws.efs.model.Destination.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription
  ): zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
