package zio.aws.efs.model
import scala.jdk.CollectionConverters._
sealed trait LifeCycleState {
  def unwrap: software.amazon.awssdk.services.efs.model.LifeCycleState
}
object LifeCycleState {
  def wrap(
      value: software.amazon.awssdk.services.efs.model.LifeCycleState
  ): zio.aws.efs.model.LifeCycleState = value match {
    case software.amazon.awssdk.services.efs.model.LifeCycleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.efs.model.LifeCycleState.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.efs.model.LifeCycleState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.efs.model.LifeCycleState.UPDATING =>
      val r = updating
      r
    case software.amazon.awssdk.services.efs.model.LifeCycleState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.efs.model.LifeCycleState.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.efs.model.LifeCycleState.ERROR =>
      val r = error
      r
  }
  case object unknownToSdkVersion extends zio.aws.efs.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.LifeCycleState =
      software.amazon.awssdk.services.efs.model.LifeCycleState.UNKNOWN_TO_SDK_VERSION
  }
  case object creating extends zio.aws.efs.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.LifeCycleState =
      software.amazon.awssdk.services.efs.model.LifeCycleState.CREATING
  }
  case object available extends zio.aws.efs.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.LifeCycleState =
      software.amazon.awssdk.services.efs.model.LifeCycleState.AVAILABLE
  }
  case object updating extends zio.aws.efs.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.LifeCycleState =
      software.amazon.awssdk.services.efs.model.LifeCycleState.UPDATING
  }
  case object deleting extends zio.aws.efs.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.LifeCycleState =
      software.amazon.awssdk.services.efs.model.LifeCycleState.DELETING
  }
  case object deleted extends zio.aws.efs.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.LifeCycleState =
      software.amazon.awssdk.services.efs.model.LifeCycleState.DELETED
  }
  case object error extends zio.aws.efs.model.LifeCycleState {
    override def unwrap
        : software.amazon.awssdk.services.efs.model.LifeCycleState =
      software.amazon.awssdk.services.efs.model.LifeCycleState.ERROR
  }
}
