package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemPolicyRequest(fileSystemId: FileSystemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest = {
    import DeleteFileSystemPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DeleteFileSystemPolicyRequest.ReadOnly =
    zio.aws.efs.model.DeleteFileSystemPolicyRequest.wrap(buildAwsValue())
}
object DeleteFileSystemPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DeleteFileSystemPolicyRequest =
      zio.aws.efs.model.DeleteFileSystemPolicyRequest(fileSystemId)
    def fileSystemId: FileSystemId
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest
  ) extends zio.aws.efs.model.DeleteFileSystemPolicyRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest
  ): zio.aws.efs.model.DeleteFileSystemPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
