package zio.aws.efs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{
  FileSystemId,
  CreationToken,
  Marker,
  MaxItems
}
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemsRequest(
    maxItems: Option[MaxItems] = None,
    marker: Option[Marker] = None,
    creationToken: Option[CreationToken] = None,
    fileSystemId: Option[FileSystemId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest = {
    import DescribeFileSystemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
      .builder()
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        creationToken.map(value =>
          CreationToken.unwrap(value): java.lang.String
        )
      )(_.creationToken)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeFileSystemsRequest.ReadOnly =
    zio.aws.efs.model.DescribeFileSystemsRequest.wrap(buildAwsValue())
}
object DescribeFileSystemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeFileSystemsRequest =
      zio.aws.efs.model.DescribeFileSystemsRequest(
        maxItems.map(value => value),
        marker.map(value => value),
        creationToken.map(value => value),
        fileSystemId.map(value => value)
      )
    def maxItems: Option[MaxItems]
    def marker: Option[Marker]
    def creationToken: Option[CreationToken]
    def fileSystemId: Option[FileSystemId]
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getCreationToken: ZIO[Any, AwsError, CreationToken] =
      AwsError.unwrapOptionField("creationToken", creationToken)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
  ) extends zio.aws.efs.model.DescribeFileSystemsRequest.ReadOnly {
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.efs.model.primitives.MaxItems(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val creationToken: Option[CreationToken] = scala
      .Option(impl.creationToken())
      .map(value => zio.aws.efs.model.primitives.CreationToken(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest
  ): zio.aws.efs.model.DescribeFileSystemsRequest.ReadOnly = new Wrapper(impl)
}
