package zio.aws.efs
import zio.aws.efs.model.DescribeAccessPointsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.efs.model.{
  DeleteFileSystemRequest,
  DescribeLifecycleConfigurationRequest,
  DeleteFileSystemPolicyRequest,
  PutFileSystemPolicyRequest,
  DescribeFileSystemsRequest,
  DescribeFileSystemPolicyRequest,
  DeleteReplicationConfigurationRequest,
  ListTagsForResourceRequest,
  CreateMountTargetRequest,
  DescribeAccessPointsRequest,
  DescribeAccountPreferencesRequest,
  DescribeMountTargetSecurityGroupsRequest,
  CreateReplicationConfigurationRequest,
  PutBackupPolicyRequest,
  DescribeMountTargetsRequest,
  UntagResourceRequest,
  UpdateFileSystemRequest,
  ModifyMountTargetSecurityGroupsRequest,
  PutAccountPreferencesRequest,
  CreateFileSystemRequest,
  PutLifecycleConfigurationRequest,
  DescribeReplicationConfigurationsRequest,
  DescribeBackupPolicyRequest,
  DeleteAccessPointRequest,
  DeleteMountTargetRequest,
  TagResourceRequest,
  CreateAccessPointRequest
}
import software.amazon.awssdk.services.efs.EfsAsyncClient
import zio.stream.ZStream
object EfsMock extends Mock[Efs] {
  object PutBackupPolicy
      extends Effect[
        PutBackupPolicyRequest,
        AwsError,
        zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly
      ]
  object CreateAccessPoint
      extends Effect[
        CreateAccessPointRequest,
        AwsError,
        zio.aws.efs.model.CreateAccessPointResponse.ReadOnly
      ]
  object UpdateFileSystem
      extends Effect[
        UpdateFileSystemRequest,
        AwsError,
        zio.aws.efs.model.UpdateFileSystemResponse.ReadOnly
      ]
  object ModifyMountTargetSecurityGroups
      extends Effect[ModifyMountTargetSecurityGroupsRequest, AwsError, Unit]
  object PutFileSystemPolicy
      extends Effect[
        PutFileSystemPolicyRequest,
        AwsError,
        zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly
      ]
  object DescribeFileSystemPolicy
      extends Effect[
        DescribeFileSystemPolicyRequest,
        AwsError,
        zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly
      ]
  object DescribeMountTargetSecurityGroups
      extends Effect[
        DescribeMountTargetSecurityGroupsRequest,
        AwsError,
        zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly
      ]
  object DeleteFileSystemPolicy
      extends Effect[DeleteFileSystemPolicyRequest, AwsError, Unit]
  object DescribeReplicationConfigurations
      extends Stream[
        DescribeReplicationConfigurationsRequest,
        AwsError,
        zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly
      ]
  object DescribeReplicationConfigurationsPaginated
      extends Effect[
        DescribeReplicationConfigurationsRequest,
        AwsError,
        zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly
      ]
  object CreateFileSystem
      extends Effect[
        CreateFileSystemRequest,
        AwsError,
        zio.aws.efs.model.CreateFileSystemResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DescribeFileSystems
      extends Effect[
        DescribeFileSystemsRequest,
        AwsError,
        zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly
      ]
  object DescribeLifecycleConfiguration
      extends Effect[
        DescribeLifecycleConfigurationRequest,
        AwsError,
        zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly
      ]
  object DeleteFileSystem
      extends Effect[DeleteFileSystemRequest, AwsError, Unit]
  object DeleteMountTarget
      extends Effect[DeleteMountTargetRequest, AwsError, Unit]
  object PutLifecycleConfiguration
      extends Effect[
        PutLifecycleConfigurationRequest,
        AwsError,
        zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.efs.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.efs.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DescribeMountTargets
      extends Effect[
        DescribeMountTargetsRequest,
        AwsError,
        zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly
      ]
  object DescribeAccessPoints
      extends Stream[
        DescribeAccessPointsRequest,
        AwsError,
        zio.aws.efs.model.AccessPointDescription.ReadOnly
      ]
  object DescribeAccessPointsPaginated
      extends Effect[DescribeAccessPointsRequest, AwsError, ReadOnly]
  object DescribeAccountPreferences
      extends Effect[
        DescribeAccountPreferencesRequest,
        AwsError,
        zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly
      ]
  object CreateMountTarget
      extends Effect[
        CreateMountTargetRequest,
        AwsError,
        zio.aws.efs.model.CreateMountTargetResponse.ReadOnly
      ]
  object DeleteAccessPoint
      extends Effect[DeleteAccessPointRequest, AwsError, Unit]
  object DeleteReplicationConfiguration
      extends Effect[DeleteReplicationConfigurationRequest, AwsError, Unit]
  object CreateReplicationConfiguration
      extends Effect[
        CreateReplicationConfigurationRequest,
        AwsError,
        zio.aws.efs.model.CreateReplicationConfigurationResponse.ReadOnly
      ]
  object DescribeBackupPolicy
      extends Effect[
        DescribeBackupPolicyRequest,
        AwsError,
        zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly
      ]
  object PutAccountPreferences
      extends Effect[
        PutAccountPreferencesRequest,
        AwsError,
        zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Efs] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Efs {
          val api: EfsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Efs = this
          def putBackupPolicy(
              request: PutBackupPolicyRequest
          ): IO[AwsError, zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly] =
            proxy(PutBackupPolicy, request)
          def createAccessPoint(request: CreateAccessPointRequest): IO[
            AwsError,
            zio.aws.efs.model.CreateAccessPointResponse.ReadOnly
          ] = proxy(CreateAccessPoint, request)
          def updateFileSystem(
              request: UpdateFileSystemRequest
          ): IO[AwsError, zio.aws.efs.model.UpdateFileSystemResponse.ReadOnly] =
            proxy(UpdateFileSystem, request)
          def modifyMountTargetSecurityGroups(
              request: ModifyMountTargetSecurityGroupsRequest
          ): IO[AwsError, Unit] =
            proxy(ModifyMountTargetSecurityGroups, request)
          def putFileSystemPolicy(request: PutFileSystemPolicyRequest): IO[
            AwsError,
            zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly
          ] = proxy(PutFileSystemPolicy, request)
          def describeFileSystemPolicy(
              request: DescribeFileSystemPolicyRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly
          ] = proxy(DescribeFileSystemPolicy, request)
          def describeMountTargetSecurityGroups(
              request: DescribeMountTargetSecurityGroupsRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly
          ] = proxy(DescribeMountTargetSecurityGroups, request)
          def deleteFileSystemPolicy(
              request: DeleteFileSystemPolicyRequest
          ): IO[AwsError, Unit] = proxy(DeleteFileSystemPolicy, request)
          def describeReplicationConfigurations(
              request: DescribeReplicationConfigurationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReplicationConfigurations, request))
          def describeReplicationConfigurationsPaginated(
              request: DescribeReplicationConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly
          ] = proxy(DescribeReplicationConfigurationsPaginated, request)
          def createFileSystem(
              request: CreateFileSystemRequest
          ): IO[AwsError, zio.aws.efs.model.CreateFileSystemResponse.ReadOnly] =
            proxy(CreateFileSystem, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def describeFileSystems(request: DescribeFileSystemsRequest): IO[
            AwsError,
            zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly
          ] = proxy(DescribeFileSystems, request)
          def describeLifecycleConfiguration(
              request: DescribeLifecycleConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly
          ] = proxy(DescribeLifecycleConfiguration, request)
          def deleteFileSystem(
              request: DeleteFileSystemRequest
          ): IO[AwsError, Unit] = proxy(DeleteFileSystem, request)
          def deleteMountTarget(
              request: DeleteMountTargetRequest
          ): IO[AwsError, Unit] = proxy(DeleteMountTarget, request)
          def putLifecycleConfiguration(
              request: PutLifecycleConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly
          ] = proxy(PutLifecycleConfiguration, request)
          def listTagsForResource(
              request: ListTagsForResourceRequest
          ): ZStream[Any, AwsError, zio.aws.efs.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTagsForResource, request))
          def listTagsForResourcePaginated(
              request: ListTagsForResourceRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResourcePaginated, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def describeMountTargets(request: DescribeMountTargetsRequest): IO[
            AwsError,
            zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly
          ] = proxy(DescribeMountTargets, request)
          def describeAccessPoints(
              request: DescribeAccessPointsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.efs.model.AccessPointDescription.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeAccessPoints, request))
          def describeAccessPointsPaginated(
              request: DescribeAccessPointsRequest
          ): IO[AwsError, ReadOnly] =
            proxy(DescribeAccessPointsPaginated, request)
          def describeAccountPreferences(
              request: DescribeAccountPreferencesRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly
          ] = proxy(DescribeAccountPreferences, request)
          def createMountTarget(request: CreateMountTargetRequest): IO[
            AwsError,
            zio.aws.efs.model.CreateMountTargetResponse.ReadOnly
          ] = proxy(CreateMountTarget, request)
          def deleteAccessPoint(
              request: DeleteAccessPointRequest
          ): IO[AwsError, Unit] = proxy(DeleteAccessPoint, request)
          def deleteReplicationConfiguration(
              request: DeleteReplicationConfigurationRequest
          ): IO[AwsError, Unit] = proxy(DeleteReplicationConfiguration, request)
          def createReplicationConfiguration(
              request: CreateReplicationConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.efs.model.CreateReplicationConfigurationResponse.ReadOnly
          ] = proxy(CreateReplicationConfiguration, request)
          def describeBackupPolicy(request: DescribeBackupPolicyRequest): IO[
            AwsError,
            zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly
          ] = proxy(DescribeBackupPolicy, request)
          def putAccountPreferences(request: PutAccountPreferencesRequest): IO[
            AwsError,
            zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly
          ] = proxy(PutAccountPreferences, request)
        }
      }
    }
    .toLayer
}
