package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.AccessPointId
import scala.jdk.CollectionConverters._
final case class DeleteAccessPointRequest(accessPointId: AccessPointId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest = {
    import DeleteAccessPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest
      .builder()
      .accessPointId(AccessPointId.unwrap(accessPointId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DeleteAccessPointRequest.ReadOnly =
    zio.aws.efs.model.DeleteAccessPointRequest.wrap(buildAwsValue())
}
object DeleteAccessPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DeleteAccessPointRequest =
      zio.aws.efs.model.DeleteAccessPointRequest(accessPointId)
    def accessPointId: AccessPointId
    def getAccessPointId: ZIO[Any, Nothing, AccessPointId] =
      ZIO.succeed(accessPointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest
  ) extends zio.aws.efs.model.DeleteAccessPointRequest.ReadOnly {
    override val accessPointId: AccessPointId =
      zio.aws.efs.model.primitives.AccessPointId(impl.accessPointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest
  ): zio.aws.efs.model.DeleteAccessPointRequest.ReadOnly = new Wrapper(impl)
}
