package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{
  SubnetId,
  VpcId,
  AvailabilityZoneId,
  NetworkInterfaceId,
  FileSystemId,
  IpAddress,
  AvailabilityZoneName,
  AwsAccountId,
  MountTargetId
}
import scala.jdk.CollectionConverters._
final case class CreateMountTargetResponse(
    ownerId: Option[AwsAccountId] = None,
    mountTargetId: MountTargetId,
    fileSystemId: FileSystemId,
    subnetId: SubnetId,
    lifeCycleState: zio.aws.efs.model.LifeCycleState,
    ipAddress: Option[IpAddress] = None,
    networkInterfaceId: Option[NetworkInterfaceId] = None,
    availabilityZoneId: Option[AvailabilityZoneId] = None,
    availabilityZoneName: Option[AvailabilityZoneName] = None,
    vpcId: Option[VpcId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.CreateMountTargetResponse = {
    import CreateMountTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.CreateMountTargetResponse
      .builder()
      .optionallyWith(
        ownerId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .mountTargetId(MountTargetId.unwrap(mountTargetId): java.lang.String)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .lifeCycleState(lifeCycleState.unwrap)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        availabilityZoneId.map(value =>
          AvailabilityZoneId.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneId)
      .optionallyWith(
        availabilityZoneName.map(value =>
          AvailabilityZoneName.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneName)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.CreateMountTargetResponse.ReadOnly =
    zio.aws.efs.model.CreateMountTargetResponse.wrap(buildAwsValue())
}
object CreateMountTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.CreateMountTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.CreateMountTargetResponse =
      zio.aws.efs.model.CreateMountTargetResponse(
        ownerId.map(value => value),
        mountTargetId,
        fileSystemId,
        subnetId,
        lifeCycleState,
        ipAddress.map(value => value),
        networkInterfaceId.map(value => value),
        availabilityZoneId.map(value => value),
        availabilityZoneName.map(value => value),
        vpcId.map(value => value)
      )
    def ownerId: Option[AwsAccountId]
    def mountTargetId: MountTargetId
    def fileSystemId: FileSystemId
    def subnetId: SubnetId
    def lifeCycleState: zio.aws.efs.model.LifeCycleState
    def ipAddress: Option[IpAddress]
    def networkInterfaceId: Option[NetworkInterfaceId]
    def availabilityZoneId: Option[AvailabilityZoneId]
    def availabilityZoneName: Option[AvailabilityZoneName]
    def vpcId: Option[VpcId]
    def getOwnerId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getMountTargetId: ZIO[Any, Nothing, MountTargetId] =
      ZIO.succeed(mountTargetId)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getLifeCycleState: ZIO[Any, Nothing, zio.aws.efs.model.LifeCycleState] =
      ZIO.succeed(lifeCycleState)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getAvailabilityZoneId: ZIO[Any, AwsError, AvailabilityZoneId] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getAvailabilityZoneName: ZIO[Any, AwsError, AvailabilityZoneName] =
      AwsError.unwrapOptionField("availabilityZoneName", availabilityZoneName)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.CreateMountTargetResponse
  ) extends zio.aws.efs.model.CreateMountTargetResponse.ReadOnly {
    override val ownerId: Option[AwsAccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.efs.model.primitives.AwsAccountId(value))
    override val mountTargetId: MountTargetId =
      zio.aws.efs.model.primitives.MountTargetId(impl.mountTargetId())
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val subnetId: SubnetId =
      zio.aws.efs.model.primitives.SubnetId(impl.subnetId())
    override val lifeCycleState: zio.aws.efs.model.LifeCycleState =
      zio.aws.efs.model.LifeCycleState.wrap(impl.lifeCycleState())
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.efs.model.primitives.IpAddress(value))
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.efs.model.primitives.NetworkInterfaceId(value))
    override val availabilityZoneId: Option[AvailabilityZoneId] = scala
      .Option(impl.availabilityZoneId())
      .map(value => zio.aws.efs.model.primitives.AvailabilityZoneId(value))
    override val availabilityZoneName: Option[AvailabilityZoneName] = scala
      .Option(impl.availabilityZoneName())
      .map(value => zio.aws.efs.model.primitives.AvailabilityZoneName(value))
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.efs.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.CreateMountTargetResponse
  ): zio.aws.efs.model.CreateMountTargetResponse.ReadOnly = new Wrapper(impl)
}
