package zio.aws.efs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{MaxResults, Token}
import scala.jdk.CollectionConverters._
final case class DescribeAccountPreferencesRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest = {
    import DescribeAccountPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeAccountPreferencesRequest.ReadOnly =
    zio.aws.efs.model.DescribeAccountPreferencesRequest.wrap(buildAwsValue())
}
object DescribeAccountPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeAccountPreferencesRequest =
      zio.aws.efs.model.DescribeAccountPreferencesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
  ) extends zio.aws.efs.model.DescribeAccountPreferencesRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest
  ): zio.aws.efs.model.DescribeAccountPreferencesRequest.ReadOnly = new Wrapper(
    impl
  )
}
