package zio.aws.efs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{Token, MaxResults, ResourceId}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceId: ResourceId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.efs.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.ListTagsForResourceRequest =
      zio.aws.efs.model.ListTagsForResourceRequest(
        resourceId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceId: ResourceId
    def maxResults: Option[MaxResults]
    def nextToken: Option[Token]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
  ) extends zio.aws.efs.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.efs.model.primitives.ResourceId(impl.resourceId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest
  ): zio.aws.efs.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
