package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class DescribeAccessPointsResponse(
    accessPoints: Option[Iterable[zio.aws.efs.model.AccessPointDescription]] =
      None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse = {
    import DescribeAccessPointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse
      .builder()
      .optionallyWith(
        accessPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessPoints)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeAccessPointsResponse.ReadOnly =
    zio.aws.efs.model.DescribeAccessPointsResponse.wrap(buildAwsValue())
}
object DescribeAccessPointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeAccessPointsResponse =
      zio.aws.efs.model.DescribeAccessPointsResponse(
        accessPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accessPoints
        : Option[List[zio.aws.efs.model.AccessPointDescription.ReadOnly]]
    def nextToken: Option[Token]
    def getAccessPoints: ZIO[Any, AwsError, List[
      zio.aws.efs.model.AccessPointDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("accessPoints", accessPoints)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse
  ) extends zio.aws.efs.model.DescribeAccessPointsResponse.ReadOnly {
    override val accessPoints
        : Option[List[zio.aws.efs.model.AccessPointDescription.ReadOnly]] =
      scala
        .Option(impl.accessPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.AccessPointDescription.wrap(item)
          }.toList
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse
  ): zio.aws.efs.model.DescribeAccessPointsResponse.ReadOnly = new Wrapper(impl)
}
