package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutLifecycleConfigurationResponse(
    lifecyclePolicies: Option[Iterable[zio.aws.efs.model.LifecyclePolicy]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse = {
    import PutLifecycleConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse
      .builder()
      .optionallyWith(
        lifecyclePolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecyclePolicies)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly =
    zio.aws.efs.model.PutLifecycleConfigurationResponse.wrap(buildAwsValue())
}
object PutLifecycleConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutLifecycleConfigurationResponse =
      zio.aws.efs.model.PutLifecycleConfigurationResponse(
        lifecyclePolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lifecyclePolicies
        : Option[List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]]
    def getLifecyclePolicies
        : ZIO[Any, AwsError, List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]] =
      AwsError.unwrapOptionField("lifecyclePolicies", lifecyclePolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse
  ) extends zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly {
    override val lifecyclePolicies
        : Option[List[zio.aws.efs.model.LifecyclePolicy.ReadOnly]] = scala
      .Option(impl.lifecyclePolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.efs.model.LifecyclePolicy.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse
  ): zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
