package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.efs.model.primitives.FileSystemId
import scala.jdk.CollectionConverters._
final case class PutBackupPolicyRequest(
    fileSystemId: FileSystemId,
    backupPolicy: zio.aws.efs.model.BackupPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest = {
    import PutBackupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .backupPolicy(backupPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.efs.model.PutBackupPolicyRequest.ReadOnly =
    zio.aws.efs.model.PutBackupPolicyRequest.wrap(buildAwsValue())
}
object PutBackupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.PutBackupPolicyRequest = zio.aws.efs.model
      .PutBackupPolicyRequest(fileSystemId, backupPolicy.asEditable)
    def fileSystemId: FileSystemId
    def backupPolicy: zio.aws.efs.model.BackupPolicy.ReadOnly
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getBackupPolicy
        : ZIO[Any, Nothing, zio.aws.efs.model.BackupPolicy.ReadOnly] =
      ZIO.succeed(backupPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest
  ) extends zio.aws.efs.model.PutBackupPolicyRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val backupPolicy: zio.aws.efs.model.BackupPolicy.ReadOnly =
      zio.aws.efs.model.BackupPolicy.wrap(impl.backupPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest
  ): zio.aws.efs.model.PutBackupPolicyRequest.ReadOnly = new Wrapper(impl)
}
