package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.efs.model.primitives.{
  FileSystemNullableSizeValue,
  Timestamp,
  FileSystemSizeValue
}
import scala.jdk.CollectionConverters._
final case class FileSystemSize(
    value: FileSystemSizeValue,
    timestamp: Option[Timestamp] = None,
    valueInIA: Option[FileSystemNullableSizeValue] = None,
    valueInStandard: Option[FileSystemNullableSizeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.FileSystemSize = {
    import FileSystemSize.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.FileSystemSize
      .builder()
      .value(FileSystemSizeValue.unwrap(value): java.lang.Long)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        valueInIA.map(value =>
          FileSystemNullableSizeValue.unwrap(value): java.lang.Long
        )
      )(_.valueInIA)
      .optionallyWith(
        valueInStandard.map(value =>
          FileSystemNullableSizeValue.unwrap(value): java.lang.Long
        )
      )(_.valueInStandard)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.FileSystemSize.ReadOnly =
    zio.aws.efs.model.FileSystemSize.wrap(buildAwsValue())
}
object FileSystemSize {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.FileSystemSize
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.FileSystemSize =
      zio.aws.efs.model.FileSystemSize(
        value,
        timestamp.map(value => value),
        valueInIA.map(value => value),
        valueInStandard.map(value => value)
      )
    def value: FileSystemSizeValue
    def timestamp: Option[Timestamp]
    def valueInIA: Option[FileSystemNullableSizeValue]
    def valueInStandard: Option[FileSystemNullableSizeValue]
    def getValue: ZIO[Any, Nothing, FileSystemSizeValue] = ZIO.succeed(value)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getValueInIA: ZIO[Any, AwsError, FileSystemNullableSizeValue] =
      AwsError.unwrapOptionField("valueInIA", valueInIA)
    def getValueInStandard: ZIO[Any, AwsError, FileSystemNullableSizeValue] =
      AwsError.unwrapOptionField("valueInStandard", valueInStandard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.FileSystemSize
  ) extends zio.aws.efs.model.FileSystemSize.ReadOnly {
    override val value: FileSystemSizeValue =
      zio.aws.efs.model.primitives.FileSystemSizeValue(impl.value())
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.efs.model.primitives.Timestamp(value))
    override val valueInIA: Option[FileSystemNullableSizeValue] = scala
      .Option(impl.valueInIA())
      .map(value =>
        zio.aws.efs.model.primitives.FileSystemNullableSizeValue(value)
      )
    override val valueInStandard: Option[FileSystemNullableSizeValue] = scala
      .Option(impl.valueInStandard())
      .map(value =>
        zio.aws.efs.model.primitives.FileSystemNullableSizeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.FileSystemSize
  ): zio.aws.efs.model.FileSystemSize.ReadOnly = new Wrapper(impl)
}
