package zio.aws.efs.model
import zio.aws.efs.model.primitives.{
  AvailabilityZoneId,
  Timestamp,
  TagValue,
  CreationToken,
  Encrypted,
  FileSystemId,
  KmsKeyId,
  AvailabilityZoneName,
  FileSystemArn,
  AwsAccountId,
  ProvisionedThroughputInMibps,
  MountTargetCount
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FileSystemDescription(
    ownerId: AwsAccountId,
    creationToken: CreationToken,
    fileSystemId: FileSystemId,
    fileSystemArn: Option[FileSystemArn] = None,
    creationTime: Timestamp,
    lifeCycleState: zio.aws.efs.model.LifeCycleState,
    name: Option[TagValue] = None,
    numberOfMountTargets: MountTargetCount,
    sizeInBytes: zio.aws.efs.model.FileSystemSize,
    performanceMode: zio.aws.efs.model.PerformanceMode,
    encrypted: Option[Encrypted] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    throughputMode: Option[zio.aws.efs.model.ThroughputMode] = None,
    provisionedThroughputInMibps: Option[ProvisionedThroughputInMibps] = None,
    availabilityZoneName: Option[AvailabilityZoneName] = None,
    availabilityZoneId: Option[AvailabilityZoneId] = None,
    tags: Iterable[zio.aws.efs.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.FileSystemDescription = {
    import FileSystemDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.FileSystemDescription
      .builder()
      .ownerId(AwsAccountId.unwrap(ownerId): java.lang.String)
      .creationToken(CreationToken.unwrap(creationToken): java.lang.String)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(
        fileSystemArn.map(value =>
          FileSystemArn.unwrap(value): java.lang.String
        )
      )(_.fileSystemArn)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lifeCycleState(lifeCycleState.unwrap)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .numberOfMountTargets(
        MountTargetCount.unwrap(numberOfMountTargets): Integer
      )
      .sizeInBytes(sizeInBytes.buildAwsValue())
      .performanceMode(performanceMode.unwrap)
      .optionallyWith(
        encrypted.map(value => Encrypted.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(throughputMode.map(value => value.unwrap))(
        _.throughputMode
      )
      .optionallyWith(
        provisionedThroughputInMibps.map(value =>
          ProvisionedThroughputInMibps.unwrap(value): java.lang.Double
        )
      )(_.provisionedThroughputInMibps)
      .optionallyWith(
        availabilityZoneName.map(value =>
          AvailabilityZoneName.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneName)
      .optionallyWith(
        availabilityZoneId.map(value =>
          AvailabilityZoneId.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneId)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.FileSystemDescription.ReadOnly =
    zio.aws.efs.model.FileSystemDescription.wrap(buildAwsValue())
}
object FileSystemDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.FileSystemDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.FileSystemDescription =
      zio.aws.efs.model.FileSystemDescription(
        ownerId,
        creationToken,
        fileSystemId,
        fileSystemArn.map(value => value),
        creationTime,
        lifeCycleState,
        name.map(value => value),
        numberOfMountTargets,
        sizeInBytes.asEditable,
        performanceMode,
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        throughputMode.map(value => value),
        provisionedThroughputInMibps.map(value => value),
        availabilityZoneName.map(value => value),
        availabilityZoneId.map(value => value),
        tags.map { item =>
          item.asEditable
        }
      )
    def ownerId: AwsAccountId
    def creationToken: CreationToken
    def fileSystemId: FileSystemId
    def fileSystemArn: Option[FileSystemArn]
    def creationTime: Timestamp
    def lifeCycleState: zio.aws.efs.model.LifeCycleState
    def name: Option[TagValue]
    def numberOfMountTargets: MountTargetCount
    def sizeInBytes: zio.aws.efs.model.FileSystemSize.ReadOnly
    def performanceMode: zio.aws.efs.model.PerformanceMode
    def encrypted: Option[Encrypted]
    def kmsKeyId: Option[KmsKeyId]
    def throughputMode: Option[zio.aws.efs.model.ThroughputMode]
    def provisionedThroughputInMibps: Option[ProvisionedThroughputInMibps]
    def availabilityZoneName: Option[AvailabilityZoneName]
    def availabilityZoneId: Option[AvailabilityZoneId]
    def tags: List[zio.aws.efs.model.Tag.ReadOnly]
    def getOwnerId: ZIO[Any, Nothing, AwsAccountId] = ZIO.succeed(ownerId)
    def getCreationToken: ZIO[Any, Nothing, CreationToken] =
      ZIO.succeed(creationToken)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getFileSystemArn: ZIO[Any, AwsError, FileSystemArn] =
      AwsError.unwrapOptionField("fileSystemArn", fileSystemArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLifeCycleState: ZIO[Any, Nothing, zio.aws.efs.model.LifeCycleState] =
      ZIO.succeed(lifeCycleState)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getNumberOfMountTargets: ZIO[Any, Nothing, MountTargetCount] =
      ZIO.succeed(numberOfMountTargets)
    def getSizeInBytes
        : ZIO[Any, Nothing, zio.aws.efs.model.FileSystemSize.ReadOnly] =
      ZIO.succeed(sizeInBytes)
    def getPerformanceMode
        : ZIO[Any, Nothing, zio.aws.efs.model.PerformanceMode] =
      ZIO.succeed(performanceMode)
    def getEncrypted: ZIO[Any, AwsError, Encrypted] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getThroughputMode
        : ZIO[Any, AwsError, zio.aws.efs.model.ThroughputMode] =
      AwsError.unwrapOptionField("throughputMode", throughputMode)
    def getProvisionedThroughputInMibps
        : ZIO[Any, AwsError, ProvisionedThroughputInMibps] =
      AwsError.unwrapOptionField(
        "provisionedThroughputInMibps",
        provisionedThroughputInMibps
      )
    def getAvailabilityZoneName: ZIO[Any, AwsError, AvailabilityZoneName] =
      AwsError.unwrapOptionField("availabilityZoneName", availabilityZoneName)
    def getAvailabilityZoneId: ZIO[Any, AwsError, AvailabilityZoneId] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getTags: ZIO[Any, Nothing, List[zio.aws.efs.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.FileSystemDescription
  ) extends zio.aws.efs.model.FileSystemDescription.ReadOnly {
    override val ownerId: AwsAccountId =
      zio.aws.efs.model.primitives.AwsAccountId(impl.ownerId())
    override val creationToken: CreationToken =
      zio.aws.efs.model.primitives.CreationToken(impl.creationToken())
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val fileSystemArn: Option[FileSystemArn] = scala
      .Option(impl.fileSystemArn())
      .map(value => zio.aws.efs.model.primitives.FileSystemArn(value))
    override val creationTime: Timestamp =
      zio.aws.efs.model.primitives.Timestamp(impl.creationTime())
    override val lifeCycleState: zio.aws.efs.model.LifeCycleState =
      zio.aws.efs.model.LifeCycleState.wrap(impl.lifeCycleState())
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.efs.model.primitives.TagValue(value))
    override val numberOfMountTargets: MountTargetCount =
      zio.aws.efs.model.primitives.MountTargetCount(impl.numberOfMountTargets())
    override val sizeInBytes: zio.aws.efs.model.FileSystemSize.ReadOnly =
      zio.aws.efs.model.FileSystemSize.wrap(impl.sizeInBytes())
    override val performanceMode: zio.aws.efs.model.PerformanceMode =
      zio.aws.efs.model.PerformanceMode.wrap(impl.performanceMode())
    override val encrypted: Option[Encrypted] = scala
      .Option(impl.encrypted())
      .map(value => zio.aws.efs.model.primitives.Encrypted(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.efs.model.primitives.KmsKeyId(value))
    override val throughputMode: Option[zio.aws.efs.model.ThroughputMode] =
      scala
        .Option(impl.throughputMode())
        .map(value => zio.aws.efs.model.ThroughputMode.wrap(value))
    override val provisionedThroughputInMibps
        : Option[ProvisionedThroughputInMibps] = scala
      .Option(impl.provisionedThroughputInMibps())
      .map(value =>
        zio.aws.efs.model.primitives.ProvisionedThroughputInMibps(value)
      )
    override val availabilityZoneName: Option[AvailabilityZoneName] = scala
      .Option(impl.availabilityZoneName())
      .map(value => zio.aws.efs.model.primitives.AvailabilityZoneName(value))
    override val availabilityZoneId: Option[AvailabilityZoneId] = scala
      .Option(impl.availabilityZoneId())
      .map(value => zio.aws.efs.model.primitives.AvailabilityZoneId(value))
    override val tags: List[zio.aws.efs.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.efs.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.FileSystemDescription
  ): zio.aws.efs.model.FileSystemDescription.ReadOnly = new Wrapper(impl)
}
