package zio.aws.efs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{MaxResults, Token, FileSystemId}
import scala.jdk.CollectionConverters._
final case class DescribeReplicationConfigurationsRequest(
    fileSystemId: Option[FileSystemId] = None,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest = {
    import DescribeReplicationConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
      .builder()
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.efs.model.DescribeReplicationConfigurationsRequest.ReadOnly =
    zio.aws.efs.model.DescribeReplicationConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeReplicationConfigurationsRequest =
      zio.aws.efs.model.DescribeReplicationConfigurationsRequest(
        fileSystemId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def fileSystemId: Option[FileSystemId]
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
  ) extends zio.aws.efs.model.DescribeReplicationConfigurationsRequest.ReadOnly {
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest
  ): zio.aws.efs.model.DescribeReplicationConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
