package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeMountTargetsResponse(
    marker: Option[Marker] = None,
    mountTargets: Option[Iterable[zio.aws.efs.model.MountTargetDescription]] =
      None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse = {
    import DescribeMountTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        mountTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountTargets)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly =
    zio.aws.efs.model.DescribeMountTargetsResponse.wrap(buildAwsValue())
}
object DescribeMountTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeMountTargetsResponse =
      zio.aws.efs.model.DescribeMountTargetsResponse(
        marker.map(value => value),
        mountTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def marker: Option[Marker]
    def mountTargets
        : Option[List[zio.aws.efs.model.MountTargetDescription.ReadOnly]]
    def nextMarker: Option[Marker]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getMountTargets: ZIO[Any, AwsError, List[
      zio.aws.efs.model.MountTargetDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("mountTargets", mountTargets)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
  ) extends zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val mountTargets
        : Option[List[zio.aws.efs.model.MountTargetDescription.ReadOnly]] =
      scala
        .Option(impl.mountTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.efs.model.MountTargetDescription.wrap(item)
          }.toList
        )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse
  ): zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly = new Wrapper(impl)
}
