package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemsResponse(
    marker: Option[Marker] = None,
    fileSystems: Option[Iterable[zio.aws.efs.model.FileSystemDescription]] =
      None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse = {
    import DescribeFileSystemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        fileSystems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystems)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly =
    zio.aws.efs.model.DescribeFileSystemsResponse.wrap(buildAwsValue())
}
object DescribeFileSystemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeFileSystemsResponse =
      zio.aws.efs.model.DescribeFileSystemsResponse(
        marker.map(value => value),
        fileSystems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def marker: Option[Marker]
    def fileSystems
        : Option[List[zio.aws.efs.model.FileSystemDescription.ReadOnly]]
    def nextMarker: Option[Marker]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getFileSystems: ZIO[Any, AwsError, List[
      zio.aws.efs.model.FileSystemDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystems", fileSystems)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
  ) extends zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val fileSystems
        : Option[List[zio.aws.efs.model.FileSystemDescription.ReadOnly]] = scala
      .Option(impl.fileSystems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.efs.model.FileSystemDescription.wrap(item)
        }.toList
      )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse
  ): zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly = new Wrapper(impl)
}
