package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{FileSystemId, ClientToken}
import scala.jdk.CollectionConverters._
final case class CreateAccessPointRequest(
    clientToken: ClientToken,
    tags: Option[Iterable[zio.aws.efs.model.Tag]] = None,
    fileSystemId: FileSystemId,
    posixUser: Option[zio.aws.efs.model.PosixUser] = None,
    rootDirectory: Option[zio.aws.efs.model.RootDirectory] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.CreateAccessPointRequest = {
    import CreateAccessPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.CreateAccessPointRequest
      .builder()
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(posixUser.map(value => value.buildAwsValue()))(
        _.posixUser
      )
      .optionallyWith(rootDirectory.map(value => value.buildAwsValue()))(
        _.rootDirectory
      )
      .build()
  }
  def asReadOnly: zio.aws.efs.model.CreateAccessPointRequest.ReadOnly =
    zio.aws.efs.model.CreateAccessPointRequest.wrap(buildAwsValue())
}
object CreateAccessPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.CreateAccessPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.CreateAccessPointRequest =
      zio.aws.efs.model.CreateAccessPointRequest(
        clientToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileSystemId,
        posixUser.map(value => value.asEditable),
        rootDirectory.map(value => value.asEditable)
      )
    def clientToken: ClientToken
    def tags: Option[List[zio.aws.efs.model.Tag.ReadOnly]]
    def fileSystemId: FileSystemId
    def posixUser: Option[zio.aws.efs.model.PosixUser.ReadOnly]
    def rootDirectory: Option[zio.aws.efs.model.RootDirectory.ReadOnly]
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.efs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getPosixUser: ZIO[Any, AwsError, zio.aws.efs.model.PosixUser.ReadOnly] =
      AwsError.unwrapOptionField("posixUser", posixUser)
    def getRootDirectory
        : ZIO[Any, AwsError, zio.aws.efs.model.RootDirectory.ReadOnly] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.CreateAccessPointRequest
  ) extends zio.aws.efs.model.CreateAccessPointRequest.ReadOnly {
    override val clientToken: ClientToken =
      zio.aws.efs.model.primitives.ClientToken(impl.clientToken())
    override val tags: Option[List[zio.aws.efs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.efs.model.Tag.wrap(item)
        }.toList
      )
    override val fileSystemId: FileSystemId =
      zio.aws.efs.model.primitives.FileSystemId(impl.fileSystemId())
    override val posixUser: Option[zio.aws.efs.model.PosixUser.ReadOnly] = scala
      .Option(impl.posixUser())
      .map(value => zio.aws.efs.model.PosixUser.wrap(value))
    override val rootDirectory
        : Option[zio.aws.efs.model.RootDirectory.ReadOnly] = scala
      .Option(impl.rootDirectory())
      .map(value => zio.aws.efs.model.RootDirectory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.CreateAccessPointRequest
  ): zio.aws.efs.model.CreateAccessPointRequest.ReadOnly = new Wrapper(impl)
}
