package zio.aws.efs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{
  FileSystemId,
  AccessPointArn,
  ClientToken,
  Name,
  AwsAccountId,
  AccessPointId
}
import scala.jdk.CollectionConverters._
final case class AccessPointDescription(
    clientToken: Option[ClientToken] = None,
    name: Option[Name] = None,
    tags: Option[Iterable[zio.aws.efs.model.Tag]] = None,
    accessPointId: Option[AccessPointId] = None,
    accessPointArn: Option[AccessPointArn] = None,
    fileSystemId: Option[FileSystemId] = None,
    posixUser: Option[zio.aws.efs.model.PosixUser] = None,
    rootDirectory: Option[zio.aws.efs.model.RootDirectory] = None,
    ownerId: Option[AwsAccountId] = None,
    lifeCycleState: Option[zio.aws.efs.model.LifeCycleState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.AccessPointDescription = {
    import AccessPointDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.AccessPointDescription
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        accessPointId.map(value =>
          AccessPointId.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .optionallyWith(
        accessPointArn.map(value =>
          AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(posixUser.map(value => value.buildAwsValue()))(
        _.posixUser
      )
      .optionallyWith(rootDirectory.map(value => value.buildAwsValue()))(
        _.rootDirectory
      )
      .optionallyWith(
        ownerId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(lifeCycleState.map(value => value.unwrap))(
        _.lifeCycleState
      )
      .build()
  }
  def asReadOnly: zio.aws.efs.model.AccessPointDescription.ReadOnly =
    zio.aws.efs.model.AccessPointDescription.wrap(buildAwsValue())
}
object AccessPointDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.AccessPointDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.AccessPointDescription =
      zio.aws.efs.model.AccessPointDescription(
        clientToken.map(value => value),
        name.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accessPointId.map(value => value),
        accessPointArn.map(value => value),
        fileSystemId.map(value => value),
        posixUser.map(value => value.asEditable),
        rootDirectory.map(value => value.asEditable),
        ownerId.map(value => value),
        lifeCycleState.map(value => value)
      )
    def clientToken: Option[ClientToken]
    def name: Option[Name]
    def tags: Option[List[zio.aws.efs.model.Tag.ReadOnly]]
    def accessPointId: Option[AccessPointId]
    def accessPointArn: Option[AccessPointArn]
    def fileSystemId: Option[FileSystemId]
    def posixUser: Option[zio.aws.efs.model.PosixUser.ReadOnly]
    def rootDirectory: Option[zio.aws.efs.model.RootDirectory.ReadOnly]
    def ownerId: Option[AwsAccountId]
    def lifeCycleState: Option[zio.aws.efs.model.LifeCycleState]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, List[zio.aws.efs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAccessPointId: ZIO[Any, AwsError, AccessPointId] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getAccessPointArn: ZIO[Any, AwsError, AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getPosixUser: ZIO[Any, AwsError, zio.aws.efs.model.PosixUser.ReadOnly] =
      AwsError.unwrapOptionField("posixUser", posixUser)
    def getRootDirectory
        : ZIO[Any, AwsError, zio.aws.efs.model.RootDirectory.ReadOnly] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
    def getOwnerId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getLifeCycleState
        : ZIO[Any, AwsError, zio.aws.efs.model.LifeCycleState] =
      AwsError.unwrapOptionField("lifeCycleState", lifeCycleState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.AccessPointDescription
  ) extends zio.aws.efs.model.AccessPointDescription.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.efs.model.primitives.ClientToken(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.efs.model.primitives.Name(value))
    override val tags: Option[List[zio.aws.efs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.efs.model.Tag.wrap(item)
        }.toList
      )
    override val accessPointId: Option[AccessPointId] = scala
      .Option(impl.accessPointId())
      .map(value => zio.aws.efs.model.primitives.AccessPointId(value))
    override val accessPointArn: Option[AccessPointArn] = scala
      .Option(impl.accessPointArn())
      .map(value => zio.aws.efs.model.primitives.AccessPointArn(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val posixUser: Option[zio.aws.efs.model.PosixUser.ReadOnly] = scala
      .Option(impl.posixUser())
      .map(value => zio.aws.efs.model.PosixUser.wrap(value))
    override val rootDirectory
        : Option[zio.aws.efs.model.RootDirectory.ReadOnly] = scala
      .Option(impl.rootDirectory())
      .map(value => zio.aws.efs.model.RootDirectory.wrap(value))
    override val ownerId: Option[AwsAccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.efs.model.primitives.AwsAccountId(value))
    override val lifeCycleState: Option[zio.aws.efs.model.LifeCycleState] =
      scala
        .Option(impl.lifeCycleState())
        .map(value => zio.aws.efs.model.LifeCycleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.AccessPointDescription
  ): zio.aws.efs.model.AccessPointDescription.ReadOnly = new Wrapper(impl)
}
