package zio.aws.efs
import zio.aws.efs.model.DescribeAccessPointsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.efs.model.{
  DeleteFileSystemRequest,
  DescribeLifecycleConfigurationRequest,
  DeleteFileSystemPolicyRequest,
  DescribeLifecycleConfigurationResponse,
  PutFileSystemPolicyRequest,
  DescribeFileSystemsRequest,
  PutAccountPreferencesResponse,
  DescribeFileSystemPolicyRequest,
  DeleteReplicationConfigurationRequest,
  DescribeFileSystemPolicyResponse,
  CreateReplicationConfigurationResponse,
  ListTagsForResourceRequest,
  Tag,
  ModifyMountTargetSecurityGroupsResponse,
  CreateMountTargetRequest,
  UpdateFileSystemResponse,
  PutLifecycleConfigurationResponse,
  DescribeAccessPointsRequest,
  ListTagsForResourceResponse,
  DescribeAccountPreferencesRequest,
  DescribeMountTargetSecurityGroupsRequest,
  UntagResourceResponse,
  DeleteReplicationConfigurationResponse,
  DeleteFileSystemPolicyResponse,
  DescribeAccountPreferencesResponse,
  CreateAccessPointResponse,
  CreateReplicationConfigurationRequest,
  AccessPointDescription,
  DeleteMountTargetResponse,
  DeleteFileSystemResponse,
  PutBackupPolicyRequest,
  DescribeBackupPolicyResponse,
  CreateFileSystemResponse,
  DescribeMountTargetsRequest,
  UntagResourceRequest,
  UpdateFileSystemRequest,
  ModifyMountTargetSecurityGroupsRequest,
  PutAccountPreferencesRequest,
  CreateFileSystemRequest,
  CreateMountTargetResponse,
  DescribeFileSystemsResponse,
  PutLifecycleConfigurationRequest,
  DescribeReplicationConfigurationsRequest,
  DeleteAccessPointResponse,
  DescribeAccessPointsResponse,
  TagResourceResponse,
  DescribeMountTargetSecurityGroupsResponse,
  PutFileSystemPolicyResponse,
  ReplicationConfigurationDescription,
  DescribeMountTargetsResponse,
  DescribeBackupPolicyRequest,
  DeleteAccessPointRequest,
  DeleteMountTargetRequest,
  TagResourceRequest,
  PutBackupPolicyResponse,
  DescribeReplicationConfigurationsResponse,
  CreateAccessPointRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.efs.{
  EfsAsyncClientBuilder,
  EfsAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Efs extends AspectSupport[Efs] {
  val api: EfsAsyncClient
  def putBackupPolicy(
      request: zio.aws.efs.model.PutBackupPolicyRequest
  ): IO[AwsError, zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly]
  def createAccessPoint(
      request: zio.aws.efs.model.CreateAccessPointRequest
  ): IO[AwsError, zio.aws.efs.model.CreateAccessPointResponse.ReadOnly]
  def updateFileSystem(
      request: zio.aws.efs.model.UpdateFileSystemRequest
  ): IO[AwsError, zio.aws.efs.model.UpdateFileSystemResponse.ReadOnly]
  def modifyMountTargetSecurityGroups(
      request: zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest
  ): IO[AwsError, Unit]
  def putFileSystemPolicy(
      request: zio.aws.efs.model.PutFileSystemPolicyRequest
  ): IO[AwsError, zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly]
  def describeFileSystemPolicy(
      request: zio.aws.efs.model.DescribeFileSystemPolicyRequest
  ): IO[AwsError, zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly]
  def describeMountTargetSecurityGroups(
      request: zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest
  ): IO[
    AwsError,
    zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly
  ]
  def deleteFileSystemPolicy(
      request: zio.aws.efs.model.DeleteFileSystemPolicyRequest
  ): IO[AwsError, Unit]
  def describeReplicationConfigurations(
      request: zio.aws.efs.model.DescribeReplicationConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly
  ]
  def describeReplicationConfigurationsPaginated(
      request: zio.aws.efs.model.DescribeReplicationConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly
  ]
  def createFileSystem(
      request: zio.aws.efs.model.CreateFileSystemRequest
  ): IO[AwsError, zio.aws.efs.model.CreateFileSystemResponse.ReadOnly]
  def untagResource(
      request: zio.aws.efs.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def describeFileSystems(
      request: zio.aws.efs.model.DescribeFileSystemsRequest
  ): IO[AwsError, zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly]
  def describeLifecycleConfiguration(
      request: zio.aws.efs.model.DescribeLifecycleConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly
  ]
  def deleteFileSystem(
      request: zio.aws.efs.model.DeleteFileSystemRequest
  ): IO[AwsError, Unit]
  def deleteMountTarget(
      request: zio.aws.efs.model.DeleteMountTargetRequest
  ): IO[AwsError, Unit]
  def putLifecycleConfiguration(
      request: zio.aws.efs.model.PutLifecycleConfigurationRequest
  ): IO[AwsError, zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.efs.model.ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.efs.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: zio.aws.efs.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.efs.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.efs.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def describeMountTargets(
      request: zio.aws.efs.model.DescribeMountTargetsRequest
  ): IO[AwsError, zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly]
  def describeAccessPoints(
      request: zio.aws.efs.model.DescribeAccessPointsRequest
  ): ZStream[Any, AwsError, zio.aws.efs.model.AccessPointDescription.ReadOnly]
  def describeAccessPointsPaginated(
      request: zio.aws.efs.model.DescribeAccessPointsRequest
  ): IO[AwsError, ReadOnly]
  def describeAccountPreferences(
      request: zio.aws.efs.model.DescribeAccountPreferencesRequest
  ): IO[AwsError, zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly]
  def createMountTarget(
      request: zio.aws.efs.model.CreateMountTargetRequest
  ): IO[AwsError, zio.aws.efs.model.CreateMountTargetResponse.ReadOnly]
  def deleteAccessPoint(
      request: zio.aws.efs.model.DeleteAccessPointRequest
  ): IO[AwsError, Unit]
  def deleteReplicationConfiguration(
      request: zio.aws.efs.model.DeleteReplicationConfigurationRequest
  ): IO[AwsError, Unit]
  def createReplicationConfiguration(
      request: zio.aws.efs.model.CreateReplicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.efs.model.CreateReplicationConfigurationResponse.ReadOnly
  ]
  def describeBackupPolicy(
      request: zio.aws.efs.model.DescribeBackupPolicyRequest
  ): IO[AwsError, zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly]
  def putAccountPreferences(
      request: zio.aws.efs.model.PutAccountPreferencesRequest
  ): IO[AwsError, zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly]
}
object Efs {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Efs] = customized(identity)
  def customized(
      customization: EfsAsyncClientBuilder => EfsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Efs] = managed(
    customization
  ).toLayer
  def managed(
      customization: EfsAsyncClientBuilder => EfsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Efs] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = EfsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[EfsAsyncClient, EfsAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[EfsAsyncClient, EfsAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new EfsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class EfsImpl[R](
      override val api: EfsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Efs
      with AwsServiceBase[R] {
    override val serviceName: String = "Efs"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EfsImpl[R1] = new EfsImpl(api, newAspect, r)
    def putBackupPolicy(
        request: zio.aws.efs.model.PutBackupPolicyRequest
    ): IO[AwsError, zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly] =
      asyncRequestResponse[PutBackupPolicyRequest, PutBackupPolicyResponse](
        "putBackupPolicy",
        api.putBackupPolicy
      )(request.buildAwsValue())
        .map(zio.aws.efs.model.PutBackupPolicyResponse.wrap)
        .provideEnvironment(r)
    def createAccessPoint(
        request: zio.aws.efs.model.CreateAccessPointRequest
    ): IO[AwsError, zio.aws.efs.model.CreateAccessPointResponse.ReadOnly] =
      asyncRequestResponse[CreateAccessPointRequest, CreateAccessPointResponse](
        "createAccessPoint",
        api.createAccessPoint
      )(request.buildAwsValue())
        .map(zio.aws.efs.model.CreateAccessPointResponse.wrap)
        .provideEnvironment(r)
    def updateFileSystem(
        request: zio.aws.efs.model.UpdateFileSystemRequest
    ): IO[AwsError, zio.aws.efs.model.UpdateFileSystemResponse.ReadOnly] =
      asyncRequestResponse[UpdateFileSystemRequest, UpdateFileSystemResponse](
        "updateFileSystem",
        api.updateFileSystem
      )(request.buildAwsValue())
        .map(zio.aws.efs.model.UpdateFileSystemResponse.wrap)
        .provideEnvironment(r)
    def modifyMountTargetSecurityGroups(
        request: zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifyMountTargetSecurityGroupsRequest,
      ModifyMountTargetSecurityGroupsResponse
    ]("modifyMountTargetSecurityGroups", api.modifyMountTargetSecurityGroups)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putFileSystemPolicy(
        request: zio.aws.efs.model.PutFileSystemPolicyRequest
    ): IO[AwsError, zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        PutFileSystemPolicyRequest,
        PutFileSystemPolicyResponse
      ]("putFileSystemPolicy", api.putFileSystemPolicy)(request.buildAwsValue())
        .map(zio.aws.efs.model.PutFileSystemPolicyResponse.wrap)
        .provideEnvironment(r)
    def describeFileSystemPolicy(
        request: zio.aws.efs.model.DescribeFileSystemPolicyRequest
    ): IO[
      AwsError,
      zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFileSystemPolicyRequest,
      DescribeFileSystemPolicyResponse
    ]("describeFileSystemPolicy", api.describeFileSystemPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.efs.model.DescribeFileSystemPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeMountTargetSecurityGroups(
        request: zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest
    ): IO[
      AwsError,
      zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMountTargetSecurityGroupsRequest,
      DescribeMountTargetSecurityGroupsResponse
    ](
      "describeMountTargetSecurityGroups",
      api.describeMountTargetSecurityGroups
    )(request.buildAwsValue())
      .map(zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteFileSystemPolicy(
        request: zio.aws.efs.model.DeleteFileSystemPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteFileSystemPolicyRequest,
      DeleteFileSystemPolicyResponse
    ]("deleteFileSystemPolicy", api.deleteFileSystemPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeReplicationConfigurations(
        request: zio.aws.efs.model.DescribeReplicationConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeReplicationConfigurationsRequest,
      DescribeReplicationConfigurationsResponse,
      ReplicationConfigurationDescription
    ](
      "describeReplicationConfigurations",
      api.describeReplicationConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.replications().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.efs.model.ReplicationConfigurationDescription.wrap(item)
      )
      .provideEnvironment(r)
    def describeReplicationConfigurationsPaginated(
        request: zio.aws.efs.model.DescribeReplicationConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationConfigurationsRequest,
      DescribeReplicationConfigurationsResponse
    ](
      "describeReplicationConfigurations",
      api.describeReplicationConfigurations
    )(request.buildAwsValue())
      .map(zio.aws.efs.model.DescribeReplicationConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def createFileSystem(
        request: zio.aws.efs.model.CreateFileSystemRequest
    ): IO[AwsError, zio.aws.efs.model.CreateFileSystemResponse.ReadOnly] =
      asyncRequestResponse[CreateFileSystemRequest, CreateFileSystemResponse](
        "createFileSystem",
        api.createFileSystem
      )(request.buildAwsValue())
        .map(zio.aws.efs.model.CreateFileSystemResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.efs.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeFileSystems(
        request: zio.aws.efs.model.DescribeFileSystemsRequest
    ): IO[AwsError, zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeFileSystemsRequest,
        DescribeFileSystemsResponse
      ]("describeFileSystems", api.describeFileSystems)(request.buildAwsValue())
        .map(zio.aws.efs.model.DescribeFileSystemsResponse.wrap)
        .provideEnvironment(r)
    def describeLifecycleConfiguration(
        request: zio.aws.efs.model.DescribeLifecycleConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLifecycleConfigurationRequest,
      DescribeLifecycleConfigurationResponse
    ]("describeLifecycleConfiguration", api.describeLifecycleConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.efs.model.DescribeLifecycleConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteFileSystem(
        request: zio.aws.efs.model.DeleteFileSystemRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteFileSystemRequest, DeleteFileSystemResponse](
        "deleteFileSystem",
        api.deleteFileSystem
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteMountTarget(
        request: zio.aws.efs.model.DeleteMountTargetRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteMountTargetRequest, DeleteMountTargetResponse](
        "deleteMountTarget",
        api.deleteMountTarget
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putLifecycleConfiguration(
        request: zio.aws.efs.model.PutLifecycleConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutLifecycleConfigurationRequest,
      PutLifecycleConfigurationResponse
    ]("putLifecycleConfiguration", api.putLifecycleConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.efs.model.PutLifecycleConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.efs.model.ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.efs.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.efs.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.efs.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.efs.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.efs.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.efs.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeMountTargets(
        request: zio.aws.efs.model.DescribeMountTargetsRequest
    ): IO[AwsError, zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeMountTargetsRequest,
        DescribeMountTargetsResponse
      ]("describeMountTargets", api.describeMountTargets)(
        request.buildAwsValue()
      ).map(zio.aws.efs.model.DescribeMountTargetsResponse.wrap)
        .provideEnvironment(r)
    def describeAccessPoints(
        request: zio.aws.efs.model.DescribeAccessPointsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.efs.model.AccessPointDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAccessPointsRequest,
      DescribeAccessPointsResponse,
      AccessPointDescription
    ](
      "describeAccessPoints",
      api.describeAccessPoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accessPoints().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.efs.model.AccessPointDescription.wrap(item))
      .provideEnvironment(r)
    def describeAccessPointsPaginated(
        request: zio.aws.efs.model.DescribeAccessPointsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DescribeAccessPointsRequest,
      DescribeAccessPointsResponse
    ]("describeAccessPoints", api.describeAccessPoints)(request.buildAwsValue())
      .map(zio.aws.efs.model.DescribeAccessPointsResponse.wrap)
      .provideEnvironment(r)
    def describeAccountPreferences(
        request: zio.aws.efs.model.DescribeAccountPreferencesRequest
    ): IO[
      AwsError,
      zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountPreferencesRequest,
      DescribeAccountPreferencesResponse
    ]("describeAccountPreferences", api.describeAccountPreferences)(
      request.buildAwsValue()
    ).map(zio.aws.efs.model.DescribeAccountPreferencesResponse.wrap)
      .provideEnvironment(r)
    def createMountTarget(
        request: zio.aws.efs.model.CreateMountTargetRequest
    ): IO[AwsError, zio.aws.efs.model.CreateMountTargetResponse.ReadOnly] =
      asyncRequestResponse[CreateMountTargetRequest, CreateMountTargetResponse](
        "createMountTarget",
        api.createMountTarget
      )(request.buildAwsValue())
        .map(zio.aws.efs.model.CreateMountTargetResponse.wrap)
        .provideEnvironment(r)
    def deleteAccessPoint(
        request: zio.aws.efs.model.DeleteAccessPointRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAccessPointRequest, DeleteAccessPointResponse](
        "deleteAccessPoint",
        api.deleteAccessPoint
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteReplicationConfiguration(
        request: zio.aws.efs.model.DeleteReplicationConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteReplicationConfigurationRequest,
      DeleteReplicationConfigurationResponse
    ]("deleteReplicationConfiguration", api.deleteReplicationConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createReplicationConfiguration(
        request: zio.aws.efs.model.CreateReplicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.efs.model.CreateReplicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationConfigurationRequest,
      CreateReplicationConfigurationResponse
    ]("createReplicationConfiguration", api.createReplicationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.efs.model.CreateReplicationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeBackupPolicy(
        request: zio.aws.efs.model.DescribeBackupPolicyRequest
    ): IO[AwsError, zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeBackupPolicyRequest,
        DescribeBackupPolicyResponse
      ]("describeBackupPolicy", api.describeBackupPolicy)(
        request.buildAwsValue()
      ).map(zio.aws.efs.model.DescribeBackupPolicyResponse.wrap)
        .provideEnvironment(r)
    def putAccountPreferences(
        request: zio.aws.efs.model.PutAccountPreferencesRequest
    ): IO[AwsError, zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly] =
      asyncRequestResponse[
        PutAccountPreferencesRequest,
        PutAccountPreferencesResponse
      ]("putAccountPreferences", api.putAccountPreferences)(
        request.buildAwsValue()
      ).map(zio.aws.efs.model.PutAccountPreferencesResponse.wrap)
        .provideEnvironment(r)
  }
  def putBackupPolicy(request: zio.aws.efs.model.PutBackupPolicyRequest): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.PutBackupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putBackupPolicy(request))
  def createAccessPoint(
      request: zio.aws.efs.model.CreateAccessPointRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.CreateAccessPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessPoint(request))
  def updateFileSystem(request: zio.aws.efs.model.UpdateFileSystemRequest): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.UpdateFileSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFileSystem(request))
  def modifyMountTargetSecurityGroups(
      request: zio.aws.efs.model.ModifyMountTargetSecurityGroupsRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyMountTargetSecurityGroups(request))
  def putFileSystemPolicy(
      request: zio.aws.efs.model.PutFileSystemPolicyRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.PutFileSystemPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFileSystemPolicy(request))
  def describeFileSystemPolicy(
      request: zio.aws.efs.model.DescribeFileSystemPolicyRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeFileSystemPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFileSystemPolicy(request))
  def describeMountTargetSecurityGroups(
      request: zio.aws.efs.model.DescribeMountTargetSecurityGroupsRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeMountTargetSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMountTargetSecurityGroups(request))
  def deleteFileSystemPolicy(
      request: zio.aws.efs.model.DeleteFileSystemPolicyRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFileSystemPolicy(request))
  def describeReplicationConfigurations(
      request: zio.aws.efs.model.DescribeReplicationConfigurationsRequest
  ): ZStream[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.ReplicationConfigurationDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReplicationConfigurations(request))
  def describeReplicationConfigurationsPaginated(
      request: zio.aws.efs.model.DescribeReplicationConfigurationsRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeReplicationConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationConfigurationsPaginated(request))
  def createFileSystem(request: zio.aws.efs.model.CreateFileSystemRequest): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.CreateFileSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFileSystem(request))
  def untagResource(
      request: zio.aws.efs.model.UntagResourceRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def describeFileSystems(
      request: zio.aws.efs.model.DescribeFileSystemsRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeFileSystemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFileSystems(request))
  def describeLifecycleConfiguration(
      request: zio.aws.efs.model.DescribeLifecycleConfigurationRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeLifecycleConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLifecycleConfiguration(request))
  def deleteFileSystem(
      request: zio.aws.efs.model.DeleteFileSystemRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFileSystem(request))
  def deleteMountTarget(
      request: zio.aws.efs.model.DeleteMountTargetRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMountTarget(request))
  def putLifecycleConfiguration(
      request: zio.aws.efs.model.PutLifecycleConfigurationRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.PutLifecycleConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putLifecycleConfiguration(request))
  def listTagsForResource(
      request: zio.aws.efs.model.ListTagsForResourceRequest
  ): ZStream[zio.aws.efs.Efs, AwsError, zio.aws.efs.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.efs.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(
      request: zio.aws.efs.model.TagResourceRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def describeMountTargets(
      request: zio.aws.efs.model.DescribeMountTargetsRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeMountTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMountTargets(request))
  def describeAccessPoints(
      request: zio.aws.efs.model.DescribeAccessPointsRequest
  ): ZStream[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.AccessPointDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAccessPoints(request))
  def describeAccessPointsPaginated(
      request: zio.aws.efs.model.DescribeAccessPointsRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeAccessPointsPaginated(request))
  def describeAccountPreferences(
      request: zio.aws.efs.model.DescribeAccountPreferencesRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeAccountPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountPreferences(request))
  def createMountTarget(
      request: zio.aws.efs.model.CreateMountTargetRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.CreateMountTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMountTarget(request))
  def deleteAccessPoint(
      request: zio.aws.efs.model.DeleteAccessPointRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccessPoint(request))
  def deleteReplicationConfiguration(
      request: zio.aws.efs.model.DeleteReplicationConfigurationRequest
  ): ZIO[zio.aws.efs.Efs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteReplicationConfiguration(request))
  def createReplicationConfiguration(
      request: zio.aws.efs.model.CreateReplicationConfigurationRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.CreateReplicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationConfiguration(request))
  def describeBackupPolicy(
      request: zio.aws.efs.model.DescribeBackupPolicyRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.DescribeBackupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBackupPolicy(request))
  def putAccountPreferences(
      request: zio.aws.efs.model.PutAccountPreferencesRequest
  ): ZIO[
    zio.aws.efs.Efs,
    AwsError,
    zio.aws.efs.model.PutAccountPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountPreferences(request))
}
