package zio.aws.efs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{
  Marker,
  FileSystemId,
  MaxItems,
  AccessPointId,
  MountTargetId
}
import scala.jdk.CollectionConverters._
final case class DescribeMountTargetsRequest(
    maxItems: Option[MaxItems] = None,
    marker: Option[Marker] = None,
    fileSystemId: Option[FileSystemId] = None,
    mountTargetId: Option[MountTargetId] = None,
    accessPointId: Option[AccessPointId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest = {
    import DescribeMountTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
      .builder()
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(
        mountTargetId.map(value =>
          MountTargetId.unwrap(value): java.lang.String
        )
      )(_.mountTargetId)
      .optionallyWith(
        accessPointId.map(value =>
          AccessPointId.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeMountTargetsRequest.ReadOnly =
    zio.aws.efs.model.DescribeMountTargetsRequest.wrap(buildAwsValue())
}
object DescribeMountTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeMountTargetsRequest =
      zio.aws.efs.model.DescribeMountTargetsRequest(
        maxItems.map(value => value),
        marker.map(value => value),
        fileSystemId.map(value => value),
        mountTargetId.map(value => value),
        accessPointId.map(value => value)
      )
    def maxItems: Option[MaxItems]
    def marker: Option[Marker]
    def fileSystemId: Option[FileSystemId]
    def mountTargetId: Option[MountTargetId]
    def accessPointId: Option[AccessPointId]
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getMountTargetId: ZIO[Any, AwsError, MountTargetId] =
      AwsError.unwrapOptionField("mountTargetId", mountTargetId)
    def getAccessPointId: ZIO[Any, AwsError, AccessPointId] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
  ) extends zio.aws.efs.model.DescribeMountTargetsRequest.ReadOnly {
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.efs.model.primitives.MaxItems(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.efs.model.primitives.Marker(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
    override val mountTargetId: Option[MountTargetId] = scala
      .Option(impl.mountTargetId())
      .map(value => zio.aws.efs.model.primitives.MountTargetId(value))
    override val accessPointId: Option[AccessPointId] = scala
      .Option(impl.accessPointId())
      .map(value => zio.aws.efs.model.primitives.AccessPointId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest
  ): zio.aws.efs.model.DescribeMountTargetsRequest.ReadOnly = new Wrapper(impl)
}
