package zio.aws.efs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.efs.model.primitives.{
  FileSystemId,
  AccessPointId,
  Token,
  MaxResults
}
import scala.jdk.CollectionConverters._
final case class DescribeAccessPointsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[Token] = None,
    accessPointId: Option[AccessPointId] = None,
    fileSystemId: Option[FileSystemId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest = {
    import DescribeAccessPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accessPointId.map(value =>
          AccessPointId.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .build()
  }
  def asReadOnly: zio.aws.efs.model.DescribeAccessPointsRequest.ReadOnly =
    zio.aws.efs.model.DescribeAccessPointsRequest.wrap(buildAwsValue())
}
object DescribeAccessPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.efs.model.DescribeAccessPointsRequest =
      zio.aws.efs.model.DescribeAccessPointsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        accessPointId.map(value => value),
        fileSystemId.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[Token]
    def accessPointId: Option[AccessPointId]
    def fileSystemId: Option[FileSystemId]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccessPointId: ZIO[Any, AwsError, AccessPointId] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
  ) extends zio.aws.efs.model.DescribeAccessPointsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.efs.model.primitives.MaxResults(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.efs.model.primitives.Token(value))
    override val accessPointId: Option[AccessPointId] = scala
      .Option(impl.accessPointId())
      .map(value => zio.aws.efs.model.primitives.AccessPointId(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.efs.model.primitives.FileSystemId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest
  ): zio.aws.efs.model.DescribeAccessPointsRequest.ReadOnly = new Wrapper(impl)
}
