package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccountSettingsResponse(
    settings: Optional[Iterable[zio.aws.ecs.model.Setting]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse = {
    import ListAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse
      .builder()
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly =
    zio.aws.ecs.model.ListAccountSettingsResponse.wrap(buildAwsValue())
}
object ListAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListAccountSettingsResponse =
      zio.aws.ecs.model.ListAccountSettingsResponse(
        settings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def settings: Optional[List[zio.aws.ecs.model.Setting.ReadOnly]]
    def nextToken: Optional[String]
    def getSettings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Setting.ReadOnly]] =
      AwsError.unwrapOptionField("settings", settings)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse
  ) extends zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly {
    override val settings: Optional[List[zio.aws.ecs.model.Setting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Setting.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse
  ): zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly = new Wrapper(impl)
}
