package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTaskDefinitionsResponse(
    taskDefinitions: Optional[Iterable[zio.aws.ecs.model.TaskDefinition]] =
      Optional.Absent,
    failures: Optional[Iterable[zio.aws.ecs.model.Failure]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse = {
    import DeleteTaskDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse
      .builder()
      .optionallyWith(
        taskDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskDefinitions)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteTaskDefinitionsResponse.ReadOnly =
    zio.aws.ecs.model.DeleteTaskDefinitionsResponse.wrap(buildAwsValue())
}
object DeleteTaskDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteTaskDefinitionsResponse =
      zio.aws.ecs.model.DeleteTaskDefinitionsResponse(
        taskDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskDefinitions
        : Optional[List[zio.aws.ecs.model.TaskDefinition.ReadOnly]]
    def failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getTaskDefinitions
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskDefinition.ReadOnly]] =
      AwsError.unwrapOptionField("taskDefinitions", taskDefinitions)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse
  ) extends zio.aws.ecs.model.DeleteTaskDefinitionsResponse.ReadOnly {
    override val taskDefinitions
        : Optional[List[zio.aws.ecs.model.TaskDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.TaskDefinition.wrap(item)
          }.toList
        )
    override val failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsResponse
  ): zio.aws.ecs.model.DeleteTaskDefinitionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
